/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.support.annotation.NonNull;
import com.getbase.android.autoprovider.SqliteSchemaHelper;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

public class SqliteViewDependenciesResolver {
    private final LoadingCache<String, ImmutableSet<String>> mDependencies = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ImmutableSet<String>>(){

        public ImmutableSet<String> load(@NonNull String viewOrTableName) throws Exception {
            viewOrTableName = viewOrTableName.toLowerCase(Locale.US);
            if (SqliteViewDependenciesResolver.this.mSchemaHelper.getTables().contains((Object)viewOrTableName)) {
                return ImmutableSet.of((Object)viewOrTableName);
            }
            Preconditions.checkArgument((boolean)SqliteViewDependenciesResolver.this.mSchemaHelper.getViews().contains((Object)viewOrTableName));
            HashSet result = Sets.newHashSet();
            String viewSqlStatement = SqliteViewDependenciesResolver.this.mSchemaHelper.getViewCreateStatement(viewOrTableName);
            for (String table : SqliteViewDependenciesResolver.this.mSchemaHelper.getTables()) {
                if (!viewSqlStatement.contains(table)) continue;
                result.add(table);
            }
            for (String view : SqliteViewDependenciesResolver.this.mSchemaHelper.getViews()) {
                if (view.equals(viewOrTableName) || !viewSqlStatement.contains(view)) continue;
                result.addAll(this.load(view));
            }
            return ImmutableSet.copyOf((Collection)result);
        }
    });
    private final SqliteSchemaHelper mSchemaHelper;

    public SqliteViewDependenciesResolver(SqliteSchemaHelper schemaHelper) {
        this.mSchemaHelper = schemaHelper;
    }

    public ImmutableSet<String> getTables(String viewOrTableName) {
        return (ImmutableSet)this.mDependencies.getUnchecked((Object)viewOrTableName);
    }
}

