/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.Iterator;
import org.chalup.thneed.ModelGraph;
import org.chalup.thneed.ModelVisitor;
import org.chalup.thneed.models.DatabaseModel;
import org.chalup.thneed.models.PojoModel;

public final class Utils {
    private Utils() {
    }

    public static <TModel extends DatabaseModel & PojoModel> ImmutableBiMap<Class<?>, String> buildClassToTableMap(ModelGraph<TModel> modelGraph) {
        final ImmutableBiMap.Builder classToTableMappingBuilder = ImmutableBiMap.builder();
        modelGraph.accept(new ModelVisitor<TModel>(){

            public void visit(TModel model) {
                classToTableMappingBuilder.put((Object)((PojoModel)model).getModelClass(), (Object)model.getTableName());
            }
        });
        return classToTableMappingBuilder.build();
    }

    static <T> Iterator<T> advancePast(@NonNull Iterator<T> iterator, @NonNull T element) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(element);
        while (iterator.hasNext() && iterator.next() != element) {
        }
        Preconditions.checkArgument((boolean)iterator.hasNext());
        return iterator;
    }
}

