/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.image;

import android.graphics.Bitmap;
import com.getbouncer.scan.framework.image.ImageTransformValues;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001d\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bJ\u001a\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/getbouncer/scan/framework/image/MLImage;", "", "bitmap", "Landroid/graphics/Bitmap;", "mean", "", "std", "(Landroid/graphics/Bitmap;FF)V", "Lcom/getbouncer/scan/framework/image/ImageTransformValues;", "(Landroid/graphics/Bitmap;Lcom/getbouncer/scan/framework/image/ImageTransformValues;Lcom/getbouncer/scan/framework/image/ImageTransformValues;)V", "width", "", "height", "imageData", "Ljava/nio/ByteBuffer;", "(IILjava/nio/ByteBuffer;)V", "getHeight", "()I", "getWidth", "getData", "toBitmap", "scan-framework_release"})
public final class MLImage {
    private final int width;
    private final int height;
    private final ByteBuffer imageData;

    @NotNull
    public final Bitmap toBitmap(float mean, float std) {
        return this.toBitmap(new ImageTransformValues(mean, mean, mean), new ImageTransformValues(std, std, std));
    }

    public static /* synthetic */ Bitmap toBitmap$default(MLImage mLImage, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 255.0f;
        }
        return mLImage.toBitmap(f, f2);
    }

    @NotNull
    public final Bitmap toBitmap(@NotNull ImageTransformValues mean, @NotNull ImageTransformValues std) {
        Intrinsics.checkNotNullParameter((Object)mean, (String)"mean");
        Intrinsics.checkNotNullParameter((Object)std, (String)"std");
        this.imageData.rewind();
        boolean bl = this.imageData.limit() == this.width * this.height;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "ByteBuffer limit does not match expected size";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        IntBuffer rgba = IntBuffer.allocate(this.width * this.height);
        while (this.imageData.hasRemaining()) {
            rgba.put(-16777216 + (MathKt.roundToInt((float)(this.imageData.getFloat() * std.getRed() + mean.getRed())) << 16) + (MathKt.roundToInt((float)(this.imageData.getFloat() * std.getGreen() + mean.getGreen())) << 8) + MathKt.roundToInt((float)(this.imageData.getFloat() * std.getBlue() + mean.getBlue())));
        }
        rgba.rewind();
        bitmap.copyPixelsFromBuffer((Buffer)rgba);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @NotNull
    public final ByteBuffer getData() {
        Buffer buffer = this.imageData.rewind();
        if (buffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        return (ByteBuffer)buffer;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public MLImage(int width, int height, @NotNull ByteBuffer imageData) {
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        this.width = width;
        this.height = height;
        this.imageData = imageData;
    }

    public MLImage(@NotNull Bitmap bitmap, float mean, float std) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this(bitmap, new ImageTransformValues(mean, mean, mean), new ImageTransformValues(std, std, std));
    }

    public /* synthetic */ MLImage(Bitmap bitmap, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            f2 = 255.0f;
        }
        this(bitmap, f, f2);
    }

    public MLImage(@NotNull Bitmap bitmap, @NotNull ImageTransformValues mean, @NotNull ImageTransformValues std) {
        int[] it;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)mean, (String)"mean");
        Intrinsics.checkNotNullParameter((Object)std, (String)"std");
        int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = nArray;
        int n = bitmap.getHeight();
        int n2 = bitmap.getWidth();
        MLImage mLImage = this;
        boolean bl3 = false;
        bitmap.getPixels(it, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        Object object = Unit.INSTANCE;
        bl = false;
        bl2 = false;
        it = nArray;
        boolean bl4 = false;
        ByteBuffer rgbFloat = ByteBuffer.allocateDirect(bitmap.getWidth() * bitmap.getHeight() * 3 * 4);
        rgbFloat.order(ByteOrder.nativeOrder());
        int[] $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        int[] nArray3 = $this$forEach$iv;
        int n3 = nArray3.length;
        for (int i = 0; i < n3; ++i) {
            int element$iv;
            int it2 = element$iv = nArray3[i];
            boolean bl5 = false;
            rgbFloat.putFloat(((float)(it2 >> 16 & 0xFF) - mean.getRed()) / std.getRed());
            rgbFloat.putFloat(((float)(it2 >> 8 & 0xFF) - mean.getGreen()) / std.getGreen());
            rgbFloat.putFloat(((float)(it2 & 0xFF) - mean.getBlue()) / std.getBlue());
        }
        Object object2 = object = rgbFloat;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"IntArray(bitmap.width * \u2026   rgbFloat\n            }");
        mLImage(n2, n, (ByteBuffer)object2);
    }
}

