/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.time;

import com.getbouncer.scan.framework.time.DurationInfiniteNegative;
import com.getbouncer.scan.framework.time.DurationInfinitePositive;
import com.getbouncer.scan.framework.time.DurationKt;
import com.getbouncer.scan.framework.time.DurationNanoseconds;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001cH\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0012H\u0096\u0002J\u0013\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u001cH\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020 H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u001cH\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0012H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020\u0000H\u0096\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0012\u0010\u000f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0012\u0010\u0017\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0012\u0010\u0019\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006\u0082\u0001\u0002-.\u00a8\u0006/"}, d2={"Lcom/getbouncer/scan/framework/time/Duration;", "", "()V", "inDays", "", "getInDays", "()D", "inHours", "getInHours", "inMicroseconds", "getInMicroseconds", "inMilliseconds", "getInMilliseconds", "inMinutes", "getInMinutes", "inMonths", "getInMonths", "inNanoseconds", "", "getInNanoseconds", "()J", "inSeconds", "getInSeconds", "inWeeks", "getInWeeks", "inYears", "getInYears", "compareTo", "", "other", "div", "denominator", "", "equals", "", "", "hashCode", "minus", "plus", "times", "multiplier", "toString", "", "unaryMinus", "Companion", "Lcom/getbouncer/scan/framework/time/DurationInfinite;", "Lcom/getbouncer/scan/framework/time/DurationNanoseconds;", "scan-framework_release"})
public abstract class Duration
implements Comparable<Duration> {
    @NotNull
    private static final Duration ZERO;
    @NotNull
    private static final Duration INFINITE;
    @NotNull
    private static final Duration NEGATIVE_INFINITE;
    @NotNull
    public static final Companion Companion;

    public abstract double getInYears();

    public abstract double getInMonths();

    public abstract double getInWeeks();

    public abstract double getInDays();

    public abstract double getInHours();

    public abstract double getInMinutes();

    public abstract double getInSeconds();

    public abstract double getInMilliseconds();

    public abstract double getInMicroseconds();

    public abstract long getInNanoseconds();

    public boolean equals(@Nullable Object other) {
        return other instanceof Duration ? this.getInNanoseconds() == ((Duration)other).getInNanoseconds() : false;
    }

    public int hashCode() {
        return (int)this.getInNanoseconds();
    }

    @NotNull
    public String toString() {
        return this.getInYears() > 1.0 ? DurationKt.access$roundTo(this.getInYears(), 2) + " years" : (this.getInMonths() > 1.0 ? DurationKt.access$roundTo(this.getInMonths(), 2) + " months" : (this.getInWeeks() > 1.0 ? DurationKt.access$roundTo(this.getInWeeks(), 2) + " weeks" : (this.getInDays() > 1.0 ? DurationKt.access$roundTo(this.getInDays(), 2) + " days" : (this.getInHours() > 1.0 ? DurationKt.access$roundTo(this.getInHours(), 2) + " hours" : (this.getInMinutes() > 1.0 ? DurationKt.access$roundTo(this.getInMinutes(), 2) + " minutes" : (this.getInSeconds() > 1.0 ? DurationKt.access$roundTo(this.getInSeconds(), 2) + " seconds" : (this.getInMilliseconds() > 1.0 ? DurationKt.access$roundTo(this.getInMilliseconds(), 2) + " milliseconds" : (this.getInMicroseconds() > 1.0 ? DurationKt.access$roundTo(this.getInMicroseconds(), 2) + " microseconds" : this.getInNanoseconds() + " nanoseconds"))))))));
    }

    @NotNull
    public Duration plus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new DurationNanoseconds(this.getInNanoseconds() + other.getInNanoseconds());
    }

    @NotNull
    public Duration minus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new DurationNanoseconds(this.getInNanoseconds() - other.getInNanoseconds());
    }

    @NotNull
    public Duration times(int multiplier) {
        return new DurationNanoseconds(this.getInNanoseconds() * (long)multiplier);
    }

    @NotNull
    public Duration times(long multiplier) {
        return new DurationNanoseconds(this.getInNanoseconds() * multiplier);
    }

    @NotNull
    public Duration times(float multiplier) {
        return new DurationNanoseconds(MathKt.roundToLong((double)((double)this.getInNanoseconds() * (double)multiplier)));
    }

    @NotNull
    public Duration times(double multiplier) {
        return new DurationNanoseconds(MathKt.roundToLong((double)((double)this.getInNanoseconds() * multiplier)));
    }

    @NotNull
    public Duration div(int denominator) {
        return new DurationNanoseconds(this.getInNanoseconds() / (long)denominator);
    }

    @NotNull
    public Duration div(long denominator) {
        return new DurationNanoseconds(this.getInNanoseconds() / denominator);
    }

    @NotNull
    public Duration div(float denominator) {
        return new DurationNanoseconds(MathKt.roundToLong((double)((double)this.getInNanoseconds() / (double)denominator)));
    }

    @NotNull
    public Duration div(double denominator) {
        return new DurationNanoseconds(MathKt.roundToLong((double)((double)this.getInNanoseconds() / denominator)));
    }

    @NotNull
    public Duration unaryMinus() {
        return new DurationNanoseconds(-this.getInNanoseconds());
    }

    @Override
    public int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long l = this.getInNanoseconds() - other.getInNanoseconds();
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    }

    private Duration() {
    }

    static {
        Companion = new Companion(null);
        ZERO = new DurationNanoseconds(0L);
        INFINITE = DurationInfinitePositive.INSTANCE;
        NEGATIVE_INFINITE = DurationInfiniteNegative.INSTANCE;
    }

    public /* synthetic */ Duration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/getbouncer/scan/framework/time/Duration$Companion;", "", "()V", "INFINITE", "Lcom/getbouncer/scan/framework/time/Duration;", "getINFINITE", "()Lcom/getbouncer/scan/framework/time/Duration;", "NEGATIVE_INFINITE", "getNEGATIVE_INFINITE", "ZERO", "getZERO", "scan-framework_release"})
    public static final class Companion {
        @NotNull
        public final Duration getZERO() {
            return ZERO;
        }

        @NotNull
        public final Duration getINFINITE() {
            return INFINITE;
        }

        @NotNull
        public final Duration getNEGATIVE_INFINITE() {
            return NEGATIVE_INFINITE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

