/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.time;

import com.getbouncer.scan.framework.time.ClockMark;
import com.getbouncer.scan.framework.time.Duration;
import com.getbouncer.scan.framework.time.DurationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0011\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\tH\u0096\u0002J\u0011\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\tH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/getbouncer/scan/framework/time/PreciseClockMark;", "Lcom/getbouncer/scan/framework/time/ClockMark;", "originMarkNanoseconds", "", "(J)V", "compareTo", "", "other", "elapsedSince", "Lcom/getbouncer/scan/framework/time/Duration;", "equals", "", "", "hasPassed", "hashCode", "isInFuture", "minus", "duration", "plus", "toMillisecondsSinceEpoch", "toString", "", "scan-framework_release"})
final class PreciseClockMark
extends ClockMark {
    private final long originMarkNanoseconds;

    @Override
    @NotNull
    public Duration elapsedSince() {
        return DurationKt.getNanoseconds(System.nanoTime() - this.originMarkNanoseconds);
    }

    @Override
    public long toMillisecondsSinceEpoch() {
        return System.currentTimeMillis() - (long)this.elapsedSince().getInMilliseconds();
    }

    @Override
    public boolean hasPassed() {
        return this.elapsedSince().compareTo(Duration.Companion.getZERO()) > 0;
    }

    @Override
    public boolean isInFuture() {
        return this.elapsedSince().compareTo(Duration.Companion.getZERO()) < 0;
    }

    @Override
    @NotNull
    public ClockMark plus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new PreciseClockMark(this.originMarkNanoseconds + duration.getInNanoseconds());
    }

    @Override
    @NotNull
    public ClockMark minus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new PreciseClockMark(this.originMarkNanoseconds + duration.getInNanoseconds());
    }

    @Override
    public int compareTo(@NotNull ClockMark other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.elapsedSince().compareTo(other.elapsedSince());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        Object object = other;
        if (object instanceof PreciseClockMark) {
            if (this.originMarkNanoseconds != ((PreciseClockMark)other).originMarkNanoseconds) return false;
            return true;
        }
        if (!(object instanceof ClockMark)) return false;
        if (this.toMillisecondsSinceEpoch() != ((ClockMark)other).toMillisecondsSinceEpoch()) return false;
        return true;
    }

    public int hashCode() {
        return ((Object)this.originMarkNanoseconds).hashCode();
    }

    @NotNull
    public String toString() {
        Duration duration = this.elapsedSince();
        boolean bl = false;
        boolean bl2 = false;
        Duration it = duration;
        boolean bl3 = false;
        return it.compareTo(Duration.Companion.getZERO()) >= 0 ? "PreciseClockMark(" + it + " ago)" : "PreciseClockMark(" + it.unaryMinus() + " in the future)";
    }

    public PreciseClockMark(long originMarkNanoseconds) {
        super(null);
        this.originMarkNanoseconds = originMarkNanoseconds;
    }
}

