/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.image;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.CheckResult;
import com.getbouncer.scan.framework.image.ImageTransformValues;
import com.getbouncer.scan.framework.image.MLImage;
import com.getbouncer.scan.framework.util.LayoutKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002H\u0007\u001a \u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0007H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u001e\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0007\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u001a \u0010\u0012\u001a\u00020\u0013*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\nH\u0007\u001a$\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\rH\u0007\u00a8\u0006\u001b"}, d2={"crop", "Landroid/graphics/Bitmap;", "Landroid/graphics/Rect;", "cropWithFill", "cropRegion", "rearrangeBySegments", "segmentMap", "", "rotate", "rotationDegrees", "", "scale", "size", "Landroid/util/Size;", "filter", "", "percentage", "scaleAndCrop", "toMLImage", "Lcom/getbouncer/scan/framework/image/MLImage;", "mean", "Lcom/getbouncer/scan/framework/image/ImageTransformValues;", "std", "zoom", "originalRegion", "newRegion", "newImageSize", "scan-framework_release"})
public final class BitmapExtensionsKt {
    @CheckResult
    @NotNull
    public static final Bitmap crop(@NotNull Bitmap $this$crop, @NotNull Rect crop) {
        Intrinsics.checkNotNullParameter((Object)$this$crop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        boolean bl = crop.left < crop.right && crop.top < crop.bottom;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot use negative crop";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = crop.left >= 0 && crop.top >= 0 && crop.bottom <= $this$crop.getHeight() && crop.right <= $this$crop.getWidth();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Crop is larger than source image";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)$this$crop, (int)crop.left, (int)crop.top, (int)crop.width(), (int)crop.height());
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(this, crop.left, crop.top, crop.width(), crop.height())");
        return bitmap;
    }

    @CheckResult
    @NotNull
    public static final Bitmap rotate(@NotNull Bitmap $this$rotate, float rotationDegrees) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        if (!(rotationDegrees == 0.0f)) {
            Matrix matrix = new Matrix();
            matrix.postRotate(rotationDegrees);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)$this$rotate, (int)0, (int)0, (int)$this$rotate.getWidth(), (int)$this$rotate.getHeight(), (Matrix)matrix, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n    val matrix = Matrix()\n    matrix.postRotate(rotationDegrees)\n    Bitmap.createBitmap(this, 0, 0, this.width, this.height, matrix, true)\n}");
            bitmap = bitmap2;
        } else {
            bitmap = $this$rotate;
        }
        return bitmap;
    }

    @CheckResult
    @NotNull
    public static final Bitmap scale(@NotNull Bitmap $this$scale, float percentage, boolean filter) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        if (percentage == 1.0f) {
            bitmap = $this$scale;
        } else {
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)$this$scale, (int)((int)((float)$this$scale.getWidth() * percentage)), (int)((int)((float)$this$scale.getHeight() * percentage)), (boolean)filter);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n    Bitmap.createScaledBitmap(\n        this,\n        (width * percentage).toInt(),\n        (height * percentage).toInt(),\n        filter\n    )\n}");
            bitmap = bitmap2;
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap scale$default(Bitmap bitmap, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BitmapExtensionsKt.scale(bitmap, f, bl);
    }

    @CheckResult
    @NotNull
    public static final Size size(@NotNull Bitmap $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return new Size($this$size.getWidth(), $this$size.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Bitmap scaleAndCrop(@NotNull Bitmap $this$scaleAndCrop, @NotNull Size size, boolean filter) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$scaleAndCrop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (size.getWidth() == $this$scaleAndCrop.getWidth() && size.getHeight() == $this$scaleAndCrop.getHeight()) {
            bitmap = $this$scaleAndCrop;
        } else {
            float f = (float)size.getWidth() / (float)$this$scaleAndCrop.getWidth();
            float f2 = (float)size.getHeight() / (float)$this$scaleAndCrop.getHeight();
            boolean bl = false;
            float scaleFactor = Math.max(f, f2);
            Bitmap scaled = BitmapExtensionsKt.scale($this$scaleAndCrop, scaleFactor, filter);
            bitmap = BitmapExtensionsKt.crop(scaled, LayoutKt.centerOn(size, LayoutKt.toRect(BitmapExtensionsKt.size(scaled))));
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap scaleAndCrop$default(Bitmap bitmap, Size size, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BitmapExtensionsKt.scaleAndCrop(bitmap, size, bl);
    }

    @CheckResult
    @NotNull
    public static final Bitmap cropWithFill(@NotNull Bitmap $this$cropWithFill, @NotNull Rect cropRegion) {
        Intrinsics.checkNotNullParameter((Object)$this$cropWithFill, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cropRegion, (String)"cropRegion");
        Rect intersectionRegion = LayoutKt.intersectionWith(LayoutKt.toRect(BitmapExtensionsKt.size($this$cropWithFill)), cropRegion);
        Bitmap result = Bitmap.createBitmap((int)cropRegion.width(), (int)cropRegion.height(), (Bitmap.Config)$this$cropWithFill.getConfig());
        Canvas canvas = new Canvas(result);
        canvas.drawColor(-7829368);
        Bitmap croppedImage = BitmapExtensionsKt.crop($this$cropWithFill, intersectionRegion);
        canvas.drawBitmap(croppedImage, LayoutKt.toRect(BitmapExtensionsKt.size(croppedImage)), LayoutKt.move(intersectionRegion, -cropRegion.left, -cropRegion.top), null);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @CheckResult
    @NotNull
    public static final Bitmap rearrangeBySegments(@NotNull Bitmap $this$rearrangeBySegments, @NotNull Map<Rect, Rect> segmentMap) {
        Map<Rect, Rect> b;
        Intrinsics.checkNotNullParameter((Object)$this$rearrangeBySegments, (String)"<this>");
        Intrinsics.checkNotNullParameter(segmentMap, (String)"segmentMap");
        if (segmentMap.isEmpty()) {
            Bitmap bitmap = Bitmap.createBitmap((int)0, (int)0, (Bitmap.Config)$this$rearrangeBySegments.getConfig());
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(0, 0, this.config)");
            return bitmap;
        }
        Iterable $this$reduce$iv = segmentMap.values();
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            Rect rect = (Rect)iterator$iv.next();
            Rect a = (Rect)accumulator$iv;
            boolean bl = false;
            int n = a.left;
            int n2 = ((Rect)b).left;
            boolean bl2 = false;
            int n3 = Math.min(n, n2);
            n = a.top;
            n2 = ((Rect)b).top;
            bl2 = false;
            int n4 = Math.min(n, n2);
            n = a.right;
            n2 = ((Rect)b).right;
            bl2 = false;
            int n5 = Math.max(n, n2);
            n = a.bottom;
            n2 = ((Rect)b).bottom;
            bl2 = false;
            accumulator$iv = new Rect(n3, n4, n5, Math.max(n, n2));
        }
        Rect newImageDimensions = (Rect)accumulator$iv;
        Size newImageSize = LayoutKt.size(newImageDimensions);
        Bitmap result = Bitmap.createBitmap((int)newImageSize.getWidth(), (int)newImageSize.getHeight(), (Bitmap.Config)$this$rearrangeBySegments.getConfig());
        Canvas canvas = new Canvas(result);
        b = segmentMap;
        boolean a = false;
        for (Map.Entry<Rect, Rect> it : b.entrySet()) {
            Rect from = it.getKey();
            Rect to = LayoutKt.move(it.getValue(), -newImageDimensions.left, -newImageDimensions.top);
            Bitmap segment = BitmapExtensionsKt.scale$default(BitmapExtensionsKt.crop($this$rearrangeBySegments, from), LayoutKt.size(to), false, 2, null);
            canvas.drawBitmap(segment, (float)to.left, (float)to.top, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @CheckResult
    @NotNull
    public static final Bitmap zoom(@NotNull Bitmap $this$zoom, @NotNull Rect originalRegion, @NotNull Rect newRegion, @NotNull Size newImageSize) {
        Intrinsics.checkNotNullParameter((Object)$this$zoom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalRegion, (String)"originalRegion");
        Intrinsics.checkNotNullParameter((Object)newRegion, (String)"newRegion");
        Intrinsics.checkNotNullParameter((Object)newImageSize, (String)"newImageSize");
        Map<Rect, Rect> regionMap = LayoutKt.resizeRegion(BitmapExtensionsKt.size($this$zoom), originalRegion, newRegion, newImageSize);
        return BitmapExtensionsKt.rearrangeBySegments($this$zoom, regionMap);
    }

    @NotNull
    public static final Bitmap scale(@NotNull Bitmap $this$scale, @NotNull Size size, boolean filter) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (size.getWidth() == $this$scale.getWidth() && size.getHeight() == $this$scale.getHeight()) {
            bitmap = $this$scale;
        } else {
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)$this$scale, (int)size.getWidth(), (int)size.getHeight(), (boolean)filter);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n        Bitmap.createScaledBitmap(this, size.width, size.height, filter)\n    }");
            bitmap = bitmap2;
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap scale$default(Bitmap bitmap, Size size, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BitmapExtensionsKt.scale(bitmap, size, bl);
    }

    @CheckResult
    @NotNull
    public static final MLImage toMLImage(@NotNull Bitmap $this$toMLImage, float mean, float std) {
        Intrinsics.checkNotNullParameter((Object)$this$toMLImage, (String)"<this>");
        return new MLImage($this$toMLImage, mean, std);
    }

    public static /* synthetic */ MLImage toMLImage$default(Bitmap bitmap, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 255.0f;
        }
        return BitmapExtensionsKt.toMLImage(bitmap, f, f2);
    }

    @CheckResult
    @NotNull
    public static final MLImage toMLImage(@NotNull Bitmap $this$toMLImage, @NotNull ImageTransformValues mean, @NotNull ImageTransformValues std) {
        Intrinsics.checkNotNullParameter((Object)$this$toMLImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mean, (String)"mean");
        Intrinsics.checkNotNullParameter((Object)std, (String)"std");
        return new MLImage($this$toMLImage, mean, std);
    }
}

