/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.media.Image;
import android.renderscript.RenderScript;
import androidx.annotation.CheckResult;
import com.getbouncer.scan.framework.exception.ImageTypeNotSupportedException;
import com.getbouncer.scan.framework.image.BitmapExtensionsKt;
import com.getbouncer.scan.framework.image.NV21Image;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0004H\u0003\u001a\u001e\u0010\u0007\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"isSupportedFormat", "", "imageFormat", "", "Landroid/media/Image;", "jpegToBitmap", "Landroid/graphics/Bitmap;", "toBitmap", "renderScript", "Landroid/renderscript/RenderScript;", "crop", "Landroid/graphics/Rect;", "scan-framework_release"})
public final class ImageExtensionsKt {
    @CheckResult
    public static final boolean isSupportedFormat(@NotNull Image $this$isSupportedFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedFormat, (String)"<this>");
        return ImageExtensionsKt.isSupportedFormat($this$isSupportedFormat.getFormat());
    }

    @CheckResult
    public static final boolean isSupportedFormat(int imageFormat) {
        boolean bl;
        int n = imageFormat;
        switch (n) {
            case 35: 
            case 256: {
                bl = true;
                break;
            }
            case 17: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @CheckResult
    @NotNull
    public static final Bitmap toBitmap(@NotNull Image $this$toBitmap, @NotNull RenderScript renderScript, @NotNull Rect crop) throws ImageTypeNotSupportedException {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderScript, (String)"renderScript");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        int n = $this$toBitmap.getFormat();
        switch (n) {
            case 17: {
                bitmap = new NV21Image($this$toBitmap).crop(crop).toBitmap(renderScript);
                break;
            }
            case 35: {
                bitmap = new NV21Image($this$toBitmap).crop(crop).toBitmap(renderScript);
                break;
            }
            case 256: {
                bitmap = BitmapExtensionsKt.crop(ImageExtensionsKt.jpegToBitmap($this$toBitmap), crop);
                break;
            }
            default: {
                throw new ImageTypeNotSupportedException($this$toBitmap.getFormat());
            }
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap toBitmap$default(Image image, RenderScript renderScript, Rect rect, int n, Object object) throws ImageTypeNotSupportedException {
        if ((n & 2) != 0) {
            rect = new Rect(0, 0, image.getWidth(), image.getHeight());
        }
        return ImageExtensionsKt.toBitmap(image, renderScript, rect);
    }

    @CheckResult
    private static final Bitmap jpegToBitmap(Image $this$jpegToBitmap) {
        boolean bl = $this$jpegToBitmap.getFormat() == 256;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Image is not in JPEG format";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBuffer imageBuffer = $this$jpegToBitmap.getPlanes()[0].getBuffer();
        byte[] imageBytes = new byte[imageBuffer.remaining()];
        imageBuffer.get(imageBytes);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(imageBytes, 0, imageBytes.size)");
        return bitmap;
    }
}

