/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.image;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import android.util.Size;
import androidx.annotation.CheckResult;
import com.getbouncer.scan.framework.exception.ImageTypeNotSupportedException;
import com.getbouncer.scan.framework.image.NV21ImageKt;
import com.getbouncer.scan.framework.util.ArrayExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0006H\u0007R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/getbouncer/scan/framework/image/NV21Image;", "", "image", "Landroid/media/Image;", "(Landroid/media/Image;)V", "yuvImage", "Landroid/graphics/YuvImage;", "(Landroid/graphics/YuvImage;)V", "width", "", "height", "nv21Data", "", "(II[B)V", "getHeight", "()I", "getNv21Data", "()[B", "size", "Landroid/util/Size;", "getSize", "()Landroid/util/Size;", "getWidth", "crop", "rect", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "rotate", "rotationDegrees", "toBitmap", "Landroid/graphics/Bitmap;", "renderScript", "Landroid/renderscript/RenderScript;", "toYuvImage", "scan-framework_release"})
public final class NV21Image {
    private final int width;
    private final int height;
    @NotNull
    private final byte[] nv21Data;
    @NotNull
    private final Size size;

    public NV21Image(int width, int height, @NotNull byte[] nv21Data) {
        Intrinsics.checkNotNullParameter((Object)nv21Data, (String)"nv21Data");
        this.width = width;
        this.height = height;
        this.nv21Data = nv21Data;
        this.size = new Size(this.width, this.height);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final byte[] getNv21Data() {
        return this.nv21Data;
    }

    public NV21Image(@NotNull Image image) throws ImageTypeNotSupportedException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = image.getFormat();
        switch (n3) {
            case 17: {
                ByteBuffer byteBuffer = image.getPlanes()[0].getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"image.planes[0].buffer");
                byArray = ArrayExtensionsKt.toByteArray(byteBuffer);
                break;
            }
            case 35: {
                byArray = NV21ImageKt.access$yuvToNV21Bytes(image);
                break;
            }
            default: {
                throw new ImageTypeNotSupportedException(image.getFormat());
            }
        }
        this(n, n2, byArray);
    }

    public NV21Image(@NotNull YuvImage yuvImage) throws ImageTypeNotSupportedException {
        Intrinsics.checkNotNullParameter((Object)yuvImage, (String)"yuvImage");
        int n = yuvImage.getWidth();
        int n2 = yuvImage.getHeight();
        int n3 = yuvImage.getYuvFormat();
        if (n3 != 17) {
            throw new ImageTypeNotSupportedException(yuvImage.getYuvFormat());
        }
        byte[] byArray = yuvImage.getYuvData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"when (yuvImage.yuvFormat) {\n            ImageFormat.NV21 -> yuvImage.yuvData\n            else -> throw ImageTypeNotSupportedException(yuvImage.yuvFormat)\n        }");
        this(n, n2, byArray);
    }

    @NotNull
    public final Size getSize() {
        return this.size;
    }

    @NotNull
    public final NV21Image crop(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return this.crop(rect.left, rect.top, rect.right, rect.bottom);
    }

    @NotNull
    public final NV21Image crop(int left, int top, int right, int bottom) {
        if (left > this.width || top > this.height) {
            return new NV21Image(0, 0, new byte[0]);
        }
        if (left == 0 && top == 0 && right == this.width && bottom == this.height) {
            return this;
        }
        int x = left * 2 / 2;
        int y = top * 2 / 2;
        int w = (right - left) * 2 / 2;
        int h = (bottom - top) * 2 / 2;
        int yUnit = w * h;
        int uv = yUnit / 2;
        byte[] nData = new byte[yUnit + uv];
        int uvIndexDst = w * h - y / 2 * w;
        int uvIndexSrc = this.width * this.height + x;
        int srcPos0 = y * this.width;
        int destPos0 = 0;
        int uvSrcPos0 = uvIndexSrc;
        int uvDestPos0 = uvIndexDst;
        int n = y;
        int n2 = y + h;
        if (n < n2) {
            do {
                int i = n++;
                System.arraycopy(this.nv21Data, srcPos0 + x, nData, destPos0, w);
                srcPos0 += this.width;
                destPos0 += w;
                if ((i & 1) != 0) continue;
                System.arraycopy(this.nv21Data, uvSrcPos0, nData, uvDestPos0, w);
                uvSrcPos0 += this.width;
                uvDestPos0 += w;
            } while (n < n2);
        }
        return new NV21Image(w, h, nData);
    }

    @NotNull
    public final NV21Image rotate(int rotationDegrees) {
        int rotation;
        boolean bl = rotationDegrees % 90 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can only rotate increments of 90 degrees";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n = rotation = rotationDegrees % 360 < 0 ? rotationDegrees % 360 + 360 : rotationDegrees % 360;
        if (rotation == 0) {
            return this;
        }
        byte[] output = new byte[this.nv21Data.length];
        int frameSize = this.width * this.height;
        boolean swap = rotation % 180 != 0;
        boolean xFlip = rotation % 270 != 0;
        boolean yFlip = rotation >= 180;
        int n2 = 0;
        int n3 = this.height;
        if (n2 < n3) {
            do {
                int j = n2++;
                int n4 = 0;
                int n5 = this.width;
                if (n4 >= n5) continue;
                do {
                    int i = n4++;
                    int yIn = j * this.width + i;
                    int uIn = frameSize + (j >> 1) * this.width + (i & 0xFFFFFFFE);
                    int vIn = uIn + 1;
                    int wOut = swap ? this.height : this.width;
                    int hOut = swap ? this.width : this.height;
                    int iSwapped = swap ? j : i;
                    int jSwapped = swap ? i : j;
                    int iOut = xFlip ? wOut - iSwapped - 1 : iSwapped;
                    int jOut = yFlip ? hOut - jSwapped - 1 : jSwapped;
                    int yOut = jOut * wOut + iOut;
                    int uOut = frameSize + (jOut >> 1) * wOut + (iOut & 0xFFFFFFFE);
                    int vOut = uOut + 1;
                    output[yOut] = (byte)(0xFF & this.nv21Data[yIn]);
                    output[uOut] = (byte)(0xFF & this.nv21Data[uIn]);
                    output[vOut] = (byte)(0xFF & this.nv21Data[vIn]);
                } while (n4 < n5);
            } while (n2 < n3);
        }
        return rotation == 270 || rotation == 90 ? new NV21Image(this.height, this.width, output) : new NV21Image(this.width, this.height, output);
    }

    @CheckResult
    @NotNull
    public final YuvImage toYuvImage() {
        return new YuvImage(this.nv21Data, 17, this.width, this.height, null);
    }

    @NotNull
    public final Bitmap toBitmap(@NotNull RenderScript renderScript) {
        Intrinsics.checkNotNullParameter((Object)renderScript, (String)"renderScript");
        Type.Builder builder = new Type.Builder(renderScript, Element.U8((RenderScript)renderScript)).setX(this.nv21Data.length);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(renderScript, Element.U8(renderScript)).setX(nv21Data.size)");
        Type.Builder yuvTypeBuilder = builder;
        Type type = yuvTypeBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"yuvTypeBuilder.create()");
        Type yuvType = type;
        Allocation yuvAllocation = Allocation.createTyped((RenderScript)renderScript, (Type)yuvType, (int)1);
        yuvAllocation.copyFrom(this.nv21Data);
        Type.Builder rgbTypeBuilder = new Type.Builder(renderScript, Element.RGBA_8888((RenderScript)renderScript));
        rgbTypeBuilder.setX(this.width);
        rgbTypeBuilder.setY(this.height);
        Allocation rgbAllocation = Allocation.createTyped((RenderScript)renderScript, (Type)rgbTypeBuilder.create());
        ScriptIntrinsicYuvToRGB yuvToRgbScript = ScriptIntrinsicYuvToRGB.create((RenderScript)renderScript, (Element)Element.RGBA_8888((RenderScript)renderScript));
        yuvToRgbScript.setInput(yuvAllocation);
        yuvToRgbScript.forEach(rgbAllocation);
        Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        rgbAllocation.copyTo(bitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }
}

