/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.renderscript.RenderScript;
import android.util.Log;
import androidx.annotation.CheckResult;
import com.getbouncer.scan.framework.Config;
import com.getbouncer.scan.framework.image.NV21ImageKt;
import com.getbouncer.scan.framework.util.ArrayExtensionsKt;
import com.getbouncer.scan.framework.util.MemoizeKt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000f\u001aM\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018\u001a9\u0010\u0019\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001a\u001a\u001b\u0010\u001b\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a2\u0006\u0002\u0010\u001c\u001a\f\u0010\u001d\u001a\u00020\u0011*\u00020\u001eH\u0003\"%\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"getRenderScript", "Lkotlin/Function1;", "Landroid/content/Context;", "Landroid/renderscript/RenderScript;", "kotlin.jvm.PlatformType", "getGetRenderScript", "()Lkotlin/jvm/functions/Function1;", "yuvPlanesToBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "planeBuffers", "", "Ljava/nio/ByteBuffer;", "(II[Ljava/nio/ByteBuffer;)Landroid/graphics/Bitmap;", "yuvPlanesToNV21Compat", "", "rowStrides", "", "pixelStrides", "format", "crop", "Landroid/graphics/Rect;", "(II[Ljava/nio/ByteBuffer;[I[IILandroid/graphics/Rect;)[B", "yuvPlanesToNV21Fast", "(II[Ljava/nio/ByteBuffer;[I[I)[B", "yuvPlanesToNV21Slow", "([Ljava/nio/ByteBuffer;)[B", "yuvToNV21Bytes", "Landroid/media/Image;", "scan-framework_release"})
public final class NV21ImageKt {
    @NotNull
    private static final Function1<Context, RenderScript> getRenderScript = MemoizeKt.memoize(getRenderScript.1.INSTANCE);

    @NotNull
    public static final Function1<Context, RenderScript> getGetRenderScript() {
        return getRenderScript;
    }

    /*
     * WARNING - void declaration
     */
    @CheckResult
    private static final byte[] yuvToNV21Bytes(Image $this$yuvToNV21Bytes) {
        ByteBuffer[] byteBufferArray;
        void $this$mapArray$iv;
        int n = $this$yuvToNV21Bytes.getWidth();
        int n2 = $this$yuvToNV21Bytes.getHeight();
        Object[] objectArray = $this$yuvToNV21Bytes.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"planes");
        objectArray = objectArray;
        int n3 = n2;
        int n4 = n;
        boolean $i$f$mapArray = false;
        int n5 = 0;
        int n6 = ((void)$this$mapArray$iv).length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n6];
        while (n5 < n6) {
            ByteBuffer byteBuffer;
            void it;
            int n7 = n5++;
            Image.Plane plane = (Image.Plane)$this$mapArray$iv[n7];
            int n8 = n7;
            byteBufferArray = byteBufferArray2;
            boolean bl = false;
            ByteBuffer byteBuffer2 = it.getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"it.buffer");
            byteBufferArray[n8] = byteBuffer = byteBuffer2;
        }
        byteBufferArray = byteBufferArray2;
        objectArray = $this$yuvToNV21Bytes.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"planes");
        int[] nArray = ArrayExtensionsKt.mapToIntArray((Object[])objectArray, yuvToNV21Bytes.2.INSTANCE);
        objectArray = $this$yuvToNV21Bytes.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"planes");
        return NV21ImageKt.yuvPlanesToNV21Fast(n4, n3, byteBufferArray, nArray, ArrayExtensionsKt.mapToIntArray((Object[])objectArray, yuvToNV21Bytes.3.INSTANCE));
    }

    @CheckResult
    @NotNull
    public static final byte[] yuvPlanesToNV21Compat(int width, int height, @NotNull ByteBuffer[] planeBuffers, @NotNull int[] rowStrides, @NotNull int[] pixelStrides, int format, @NotNull Rect crop) {
        Intrinsics.checkNotNullParameter((Object)planeBuffers, (String)"planeBuffers");
        Intrinsics.checkNotNullParameter((Object)rowStrides, (String)"rowStrides");
        Intrinsics.checkNotNullParameter((Object)pixelStrides, (String)"pixelStrides");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        int cropWidth = crop.width();
        int cropHeight = crop.height();
        byte[] nv21Bytes = new byte[cropWidth * cropHeight * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[rowStrides[0]];
        int channelOffset = 0;
        int outputStride = 1;
        int n = 0;
        int n2 = planeBuffers.length + -1;
        if (n <= n2) {
            do {
                int i;
                int n3 = i = n++;
                switch (n3) {
                    case 0: {
                        channelOffset = 0;
                        outputStride = 1;
                        break;
                    }
                    case 1: {
                        channelOffset = cropWidth * cropHeight + 1;
                        outputStride = 2;
                        break;
                    }
                    case 2: {
                        channelOffset = cropWidth * cropHeight;
                        outputStride = 2;
                    }
                }
                ByteBuffer buffer = planeBuffers[i];
                int rowStride = rowStrides[i];
                int pixelStride = pixelStrides[i];
                int shift = i == 0 ? 0 : 1;
                int w = cropWidth >> shift;
                int h = cropHeight >> shift;
                buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
                int n4 = 0;
                if (n4 >= h) continue;
                do {
                    int row = n4++;
                    int length = 0;
                    if (pixelStride == 1 && outputStride == 1) {
                        length = w;
                        buffer.get(nv21Bytes, channelOffset, length);
                        channelOffset += length;
                    } else {
                        length = (w - 1) * pixelStride + 1;
                        buffer.get(rowData, 0, length);
                        int n5 = 0;
                        if (n5 < w) {
                            do {
                                int col = n5++;
                                nv21Bytes[channelOffset] = rowData[col * pixelStride];
                                channelOffset += outputStride;
                            } while (n5 < w);
                        }
                    }
                    if (row >= h - 1) continue;
                    buffer.position(buffer.position() + rowStride - length);
                } while (n4 < h);
            } while (n <= n2);
        }
        return nv21Bytes;
    }

    public static /* synthetic */ byte[] yuvPlanesToNV21Compat$default(int n, int n2, ByteBuffer[] byteBufferArray, int[] nArray, int[] nArray2, int n3, Rect rect, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            rect = new Rect(0, 0, n, n2);
        }
        return NV21ImageKt.yuvPlanesToNV21Compat(n, n2, byteBufferArray, nArray, nArray2, n3, rect);
    }

    @CheckResult
    @NotNull
    public static final byte[] yuvPlanesToNV21Slow(@NotNull ByteBuffer[] planeBuffers) {
        Intrinsics.checkNotNullParameter((Object)planeBuffers, (String)"planeBuffers");
        byte[] rez = null;
        ByteBuffer buffer0 = planeBuffers[0];
        ByteBuffer buffer1 = planeBuffers[1];
        ByteBuffer buffer2 = planeBuffers[2];
        int buffer0Size = buffer0.remaining();
        int buffer1Size = buffer1.remaining();
        int buffer2Size = 1;
        byte[] buffer0Byte = new byte[buffer0Size];
        byte[] buffer1Byte = new byte[buffer1Size];
        byte[] buffer2Byte = new byte[buffer2Size];
        buffer0.get(buffer0Byte, 0, buffer0Size);
        buffer1.get(buffer1Byte, 0, buffer1Size);
        buffer2.get(buffer2Byte, buffer2Size - 1, buffer2Size);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(buffer0Byte);
            outputStream.write(buffer2Byte);
            outputStream.write(buffer1Byte);
        }
        catch (IOException e) {
            Log.e((String)Config.INSTANCE.getLogTag(), (String)"Error converting image from YUV to NV21");
        }
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        rez = byArray;
        return rez;
    }

    @NotNull
    public static final byte[] yuvPlanesToNV21Fast(int width, int height, @NotNull ByteBuffer[] planeBuffers, @NotNull int[] rowStrides, @NotNull int[] pixelStrides) {
        int n;
        int pos;
        Intrinsics.checkNotNullParameter((Object)planeBuffers, (String)"planeBuffers");
        Intrinsics.checkNotNullParameter((Object)rowStrides, (String)"rowStrides");
        Intrinsics.checkNotNullParameter((Object)pixelStrides, (String)"pixelStrides");
        int ySize = width * height;
        int uvSize = width * height / 4;
        byte[] nv21 = new byte[ySize + uvSize * 2];
        ByteBuffer yBuffer = planeBuffers[0];
        ByteBuffer uBuffer = planeBuffers[1];
        ByteBuffer vBuffer = planeBuffers[2];
        int rowStride = rowStrides[0];
        boolean bl = pixelStrides[0] == 1;
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        byte by = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (rowStride == width) {
            yBuffer.get(nv21, 0, ySize);
            pos += ySize;
        } else {
            long yBufferPos = -((long)rowStride);
            for (pos = 0; pos < ySize; pos += width) {
                yBuffer.position((int)(yBufferPos += (long)rowStride));
                yBuffer.get(nv21, pos, width);
            }
        }
        rowStride = rowStrides[2];
        int pixelStride = pixelStrides[2];
        n2 = rowStride == rowStrides[1] ? 1 : 0;
        by = 0;
        boolean bl4 = false;
        bl4 = false;
        int n3 = 0;
        if (n2 == 0) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n2 = pixelStride == pixelStrides[1] ? 1 : 0;
        by = 0;
        bl4 = false;
        bl4 = false;
        n3 = 0;
        if (n2 == 0) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (pixelStride == 2 && rowStride == width && uBuffer.get(0) == vBuffer.get(1)) {
            byte savePixel = vBuffer.get(1);
            try {
                by = savePixel;
                bl4 = false;
                vBuffer.put(1, ~by);
                by = savePixel;
                bl4 = false;
                if (uBuffer.get(0) == (byte)(~by)) {
                    vBuffer.put(1, savePixel);
                    vBuffer.position(0);
                    uBuffer.position(0);
                    vBuffer.get(nv21, ySize, 1);
                    uBuffer.get(nv21, ySize + 1, uBuffer.remaining());
                    return nv21;
                }
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                // empty catch block
            }
            vBuffer.put(1, savePixel);
        }
        if ((n2 = 0) < (n = height / 2)) {
            do {
                int row = n2++;
                n3 = 0;
                int n4 = width / 2;
                if (n3 >= n4) continue;
                do {
                    int col = n3++;
                    int vuPos = col * pixelStride + row * rowStride;
                    int n5 = pos;
                    pos = n5 + 1;
                    nv21[n5] = vBuffer.get(vuPos);
                    n5 = pos;
                    pos = n5 + 1;
                    nv21[n5] = uBuffer.get(vuPos);
                } while (n3 < n4);
            } while (n2 < n);
        }
        return nv21;
    }

    @NotNull
    public static final Bitmap yuvPlanesToBitmap(int width, int height, @NotNull ByteBuffer[] planeBuffers) {
        Intrinsics.checkNotNullParameter((Object)planeBuffers, (String)"planeBuffers");
        ByteArrayOutputStream bitmap = new ByteArrayOutputStream();
        new YuvImage(ArrayExtensionsKt.toByteArray(ArraysKt.toList((Object[])planeBuffers)), 17, width, height, null).compressToJpeg(new Rect(0, 0, width, height), 95, (OutputStream)bitmap);
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])bitmap.toByteArray(), (int)0, (int)bitmap.size());
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decodeByteArray(bitmap.toByteArray(), 0, bitmap.size())");
        return bitmap2;
    }

    public static final /* synthetic */ byte[] access$yuvToNV21Bytes(Image $receiver) {
        return NV21ImageKt.yuvToNV21Bytes($receiver);
    }
}

