/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.util;

import android.util.Log;
import com.getbouncer.scan.framework.Config;
import com.getbouncer.scan.framework.time.Clock;
import com.getbouncer.scan.framework.time.ClockMark;
import com.getbouncer.scan.framework.time.Duration;
import com.getbouncer.scan.framework.time.DurationKt;
import com.getbouncer.scan.framework.time.Rate;
import com.getbouncer.scan.framework.util.FrameRateListener;
import com.getbouncer.scan.framework.util.FrameRateTracker;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0006\u0010\u0017\u001a\u00020\u0014J\u0011\u0010\u0018\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/getbouncer/scan/framework/util/FrameRateTracker;", "", "name", "", "listener", "Lcom/getbouncer/scan/framework/util/FrameRateListener;", "notifyInterval", "Lcom/getbouncer/scan/framework/time/Duration;", "(Ljava/lang/String;Lcom/getbouncer/scan/framework/util/FrameRateListener;Lcom/getbouncer/scan/framework/time/Duration;)V", "firstFrameTime", "Lcom/getbouncer/scan/framework/time/ClockMark;", "frameRateMutex", "Lkotlinx/coroutines/sync/Mutex;", "framesProcessedSinceLastUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "lastNotifyTime", "totalFramesProcessed", "getAverageFrameRate", "Lcom/getbouncer/scan/framework/time/Rate;", "logProcessingRate", "", "overallRate", "instantRate", "reset", "trackFrameProcessed", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scan-framework_release"})
public final class FrameRateTracker {
    @NotNull
    private final String name;
    @Nullable
    private final FrameRateListener listener;
    @NotNull
    private final Duration notifyInterval;
    @Nullable
    private ClockMark firstFrameTime;
    @NotNull
    private ClockMark lastNotifyTime;
    @NotNull
    private final AtomicLong totalFramesProcessed;
    @NotNull
    private final AtomicLong framesProcessedSinceLastUpdate;
    @NotNull
    private final Mutex frameRateMutex;

    public FrameRateTracker(@NotNull String name, @Nullable FrameRateListener listener, @NotNull Duration notifyInterval) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)notifyInterval, (String)"notifyInterval");
        this.name = name;
        this.listener = listener;
        this.notifyInterval = notifyInterval;
        this.lastNotifyTime = Clock.INSTANCE.markNow();
        this.totalFramesProcessed = new AtomicLong(-1L);
        this.framesProcessedSinceLastUpdate = new AtomicLong(0L);
        this.frameRateMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public /* synthetic */ FrameRateTracker(String string, FrameRateListener frameRateListener, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frameRateListener = null;
        }
        if ((n & 4) != 0) {
            duration = DurationKt.getSeconds(1);
        }
        this(string, frameRateListener, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object trackFrameProcessed(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof trackFrameProcessed.1)) ** GOTO lbl-1000
        var15_2 = var1_1;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrameRateTracker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.trackFrameProcessed((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                totalFrames = this.totalFramesProcessed.incrementAndGet();
                framesSinceLastUpdate = this.framesProcessedSinceLastUpdate.incrementAndGet();
                lastNotifyTime = this.lastNotifyTime;
                if (totalFrames <= 0L) ** GOTO lbl-1000
                $this$withLock_u24default$iv = this.frameRateMutex;
                owner$iv = null;
                $i$f$withLock = false;
                var11_12 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = lastNotifyTime;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.J$0 = totalFrames;
                $continuation.J$1 = framesSinceLastUpdate;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock((Object)owner$iv, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl40
            }
            case 1: {
                $i$f$withLock = false;
                framesSinceLastUpdate = $continuation.J$1;
                totalFrames = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                lastNotifyTime = (ClockMark)$continuation.L$1;
                this = (FrameRateTracker)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl40:
                // 2 sources

                try {
                    $i$a$-withLock$default-FrameRateTracker$trackFrameProcessed$shouldNotifyOfFrameRate$1 = false;
                    v1 = shouldNotify = lastNotifyTime.elapsedSince().compareTo(this.notifyInterval) > 0;
                    if (shouldNotify) {
                        this.lastNotifyTime = Clock.INSTANCE.markNow();
                    }
                    var11_13 = Boxing.boxBoolean((boolean)(shouldNotify != false));
                }
                finally {
                    $this$withLock_u24default$iv.unlock((Object)owner$iv);
                }
                if (var11_13.booleanValue()) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                shouldNotifyOfFrameRate = v2;
                owner$iv = this.firstFrameTime;
                this.firstFrameTime = firstFrameTime = owner$iv == null ? Clock.INSTANCE.markNow() : owner$iv;
                if (shouldNotifyOfFrameRate) {
                    overallFrameRate = new Rate(totalFrames, firstFrameTime.elapsedSince());
                    instantFrameRate = new Rate(framesSinceLastUpdate, lastNotifyTime.elapsedSince());
                    this.logProcessingRate(overallFrameRate, instantFrameRate);
                    var11_13 = this.listener;
                    if (var11_13 != null) {
                        var11_13.onFrameRateUpdate(overallFrameRate, instantFrameRate);
                    }
                    this.framesProcessedSinceLastUpdate.set(0L);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void reset() {
        this.firstFrameTime = null;
        this.lastNotifyTime = Clock.INSTANCE.markNow();
        this.totalFramesProcessed.set(0L);
        this.framesProcessedSinceLastUpdate.set(0L);
    }

    @NotNull
    public final Rate getAverageFrameRate() {
        ClockMark clockMark = this.firstFrameTime;
        Duration duration = clockMark == null ? null : clockMark.elapsedSince();
        return new Rate(this.totalFramesProcessed.get(), duration == null ? Duration.Companion.getZERO() : duration);
    }

    private final void logProcessingRate(Rate overallRate, Rate instantRate) {
        double overallFps = !Intrinsics.areEqual((Object)overallRate.getDuration(), (Object)Duration.Companion.getZERO()) ? (double)overallRate.getAmount() / overallRate.getDuration().getInSeconds() : 0.0;
        double instantFps = !Intrinsics.areEqual((Object)instantRate.getDuration(), (Object)Duration.Companion.getZERO()) ? (double)instantRate.getAmount() / instantRate.getDuration().getInSeconds() : 0.0;
        if (Config.INSTANCE.isDebug()) {
            Log.d((String)Config.INSTANCE.getLogTag(), (String)(this.name + " processing avg=" + overallFps + ", inst=" + instantFps));
        }
    }
}

