/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.framework.util;

import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import android.util.SizeF;
import android.view.View;
import androidx.annotation.CheckResult;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\tH\u0007\u001a\u001c\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u000b\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u000f\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u001a\u001c\u0010\u0010\u001a\u00020\t*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u001a\u001c\u0010\u0010\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u0014\u001a\u00020\t*\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0007\u001a\u001c\u0010\u0014\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\tH\u0007\u001a\u001c\u0010\u0014\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0007\u001a\u001c\u0010\u0014\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0007\u001a\u001c\u0010\u0014\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\tH\u0007\u001a\u001c\u0010\u0014\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0007\u001a0\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0019*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u001d\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u001d\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u001a\u0014\u0010 \u001a\u00020\t*\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\"\u001a\u00020\t*\u00020\u00012\u0006\u0010#\u001a\u00020\tH\u0007\u001a\u0014\u0010\"\u001a\u00020\t*\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0007\u001a\u001c\u0010%\u001a\u00020\t*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u001a\u0014\u0010&\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010'\u001a\u00020\u0001H\u0007\u001a\n\u0010(\u001a\u00020\u0001*\u00020\t\u001a\n\u0010(\u001a\u00020\u0007*\u00020\u000e\u001a\n\u0010(\u001a\u00020\u0001*\u00020)\u001a\f\u0010\u0015\u001a\u00020\t*\u00020\u000eH\u0007\u001a\f\u0010\u0015\u001a\u00020\t*\u00020\u0001H\u0007\u001a\f\u0010*\u001a\u00020\u000e*\u00020\tH\u0007\u001a\f\u0010*\u001a\u00020\u000e*\u00020\u0001H\u0007\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0007H\u0007\u001a\f\u0010+\u001a\u00020\u0007*\u00020\u0001H\u0007\u001a\f\u0010,\u001a\u00020\u0001*\u00020\u0001H\u0007\u00a8\u0006-"}, d2={"adjustSizeToAspectRatio", "Landroid/util/Size;", "area", "aspectRatio", "", "maxAspectRatioInSize", "minAspectRatioSurroundingSize", "Landroid/util/SizeF;", "centerOn", "Landroid/graphics/Rect;", "rect", "centerScaled", "scaleX", "scaleY", "Landroid/graphics/RectF;", "intersectionWith", "move", "relativeX", "", "relativeY", "projectRegionOfInterest", "toRect", "regionOfInterest", "toSize", "resizeRegion", "", "originalRegion", "newRegion", "newSize", "scale", "x", "y", "scaleAndCenterSurrounding", "surroundedSize", "scaleAndCenterWithin", "containingRect", "containingSize", "scaleCentered", "scaled", "scaledSize", "size", "Landroid/view/View;", "toRectF", "toSizeF", "transpose", "scan-framework_release"})
public final class LayoutKt {
    @CheckResult
    @NotNull
    public static final Size maxAspectRatioInSize(@NotNull Size area, float aspectRatio) {
        Size size;
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        int width = area.getWidth();
        int height = MathKt.roundToInt((float)((float)width / aspectRatio));
        if (height <= area.getHeight()) {
            size = new Size(area.getWidth(), height);
        } else {
            height = area.getHeight();
            width = MathKt.roundToInt((float)((float)height * aspectRatio));
            int n = area.getWidth();
            boolean bl = false;
            Size size2 = new Size(Math.min(width, n), height);
            size = size2;
        }
        return size;
    }

    @CheckResult
    @NotNull
    public static final Size minAspectRatioSurroundingSize(@NotNull Size area, float aspectRatio) {
        Size size;
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        int width = area.getWidth();
        int height = MathKt.roundToInt((float)((float)width / aspectRatio));
        if (height >= area.getHeight()) {
            size = new Size(area.getWidth(), height);
        } else {
            height = area.getHeight();
            width = MathKt.roundToInt((float)((float)height * aspectRatio));
            int n = area.getWidth();
            boolean bl = false;
            Size size2 = new Size(Math.max(width, n), height);
            size = size2;
        }
        return size;
    }

    @CheckResult
    @NotNull
    public static final Size adjustSizeToAspectRatio(@NotNull Size area, float aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        return aspectRatio < 1.0f ? new Size(area.getWidth(), MathKt.roundToInt((float)((float)area.getWidth() / aspectRatio))) : new Size(MathKt.roundToInt((float)((float)area.getHeight() * aspectRatio)), area.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Rect scaleAndCenterWithin(@NotNull Size $this$scaleAndCenterWithin, @NotNull Size containingSize) {
        Intrinsics.checkNotNullParameter((Object)$this$scaleAndCenterWithin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingSize, (String)"containingSize");
        float aspectRatio = (float)$this$scaleAndCenterWithin.getWidth() / (float)$this$scaleAndCenterWithin.getHeight();
        Size scaledSize = LayoutKt.maxAspectRatioInSize(containingSize, aspectRatio);
        int left = (containingSize.getWidth() - scaledSize.getWidth()) / 2;
        int top = (containingSize.getHeight() - scaledSize.getHeight()) / 2;
        return new Rect(left, top, left + scaledSize.getWidth(), top + scaledSize.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Rect scaleAndCenterWithin(@NotNull Size $this$scaleAndCenterWithin, @NotNull Rect containingRect) {
        Intrinsics.checkNotNullParameter((Object)$this$scaleAndCenterWithin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingRect, (String)"containingRect");
        return LayoutKt.move(LayoutKt.scaleAndCenterWithin($this$scaleAndCenterWithin, LayoutKt.size(containingRect)), containingRect.left, containingRect.top);
    }

    @CheckResult
    @NotNull
    public static final Rect scaleAndCenterSurrounding(@NotNull Size $this$scaleAndCenterSurrounding, @NotNull Size surroundedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$scaleAndCenterSurrounding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)surroundedSize, (String)"surroundedSize");
        float aspectRatio = (float)$this$scaleAndCenterSurrounding.getWidth() / (float)$this$scaleAndCenterSurrounding.getHeight();
        Size scaledSize = LayoutKt.minAspectRatioSurroundingSize(surroundedSize, aspectRatio);
        int left = (surroundedSize.getWidth() - scaledSize.getWidth()) / 2;
        int top = (surroundedSize.getHeight() - scaledSize.getHeight()) / 2;
        return new Rect(left, top, left + scaledSize.getWidth(), top + scaledSize.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Rect scaleCentered(@NotNull Size $this$scaleCentered, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)$this$scaleCentered, (String)"<this>");
        Size newSize = LayoutKt.scale($this$scaleCentered, x, y);
        int left = ($this$scaleCentered.getWidth() - newSize.getWidth()) / 2;
        int top = ($this$scaleCentered.getHeight() - newSize.getHeight()) / 2;
        return new Rect(left, top, left + newSize.getWidth(), top + newSize.getHeight());
    }

    @CheckResult
    @NotNull
    public static final SizeF scale(@NotNull SizeF $this$scale, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        return new SizeF($this$scale.getWidth() * x, $this$scale.getHeight() * y);
    }

    @CheckResult
    @NotNull
    public static final SizeF scale(@NotNull SizeF $this$scale, float scale) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        return LayoutKt.scale($this$scale, scale, scale);
    }

    @CheckResult
    @NotNull
    public static final Size scale(@NotNull Size $this$scale, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        return new Size(MathKt.roundToInt((float)((float)$this$scale.getWidth() * x)), MathKt.roundToInt((float)((float)$this$scale.getHeight() * y)));
    }

    @CheckResult
    @NotNull
    public static final Size scale(@NotNull Size $this$scale, float scale) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        return LayoutKt.scale($this$scale, scale, scale);
    }

    @CheckResult
    @NotNull
    public static final Rect centerOn(@NotNull Size $this$centerOn, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$centerOn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new Rect(rect.centerX() - $this$centerOn.getWidth() / 2, rect.centerY() - $this$centerOn.getHeight() / 2, rect.centerX() + $this$centerOn.getWidth() / 2, rect.centerY() + $this$centerOn.getHeight() / 2);
    }

    @CheckResult
    @NotNull
    public static final RectF scaled(@NotNull RectF $this$scaled, @NotNull Size scaledSize) {
        Intrinsics.checkNotNullParameter((Object)$this$scaled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scaledSize, (String)"scaledSize");
        return new RectF($this$scaled.left * (float)scaledSize.getWidth(), $this$scaled.top * (float)scaledSize.getHeight(), $this$scaled.right * (float)scaledSize.getWidth(), $this$scaled.bottom * (float)scaledSize.getHeight());
    }

    @CheckResult
    @NotNull
    public static final RectF centerScaled(@NotNull RectF $this$centerScaled, float scaleX, float scaleY) {
        Intrinsics.checkNotNullParameter((Object)$this$centerScaled, (String)"<this>");
        return new RectF($this$centerScaled.centerX() - $this$centerScaled.width() * scaleX / (float)2, $this$centerScaled.centerY() - $this$centerScaled.height() * scaleY / (float)2, $this$centerScaled.centerX() + $this$centerScaled.width() * scaleX / (float)2, $this$centerScaled.centerY() + $this$centerScaled.height() * scaleY / (float)2);
    }

    @CheckResult
    @NotNull
    public static final Rect centerScaled(@NotNull Rect $this$centerScaled, float scaleX, float scaleY) {
        Intrinsics.checkNotNullParameter((Object)$this$centerScaled, (String)"<this>");
        return new Rect($this$centerScaled.centerX() - (int)((float)$this$centerScaled.width() * scaleX / (float)2), $this$centerScaled.centerY() - (int)((float)$this$centerScaled.height() * scaleY / (float)2), $this$centerScaled.centerX() + (int)((float)$this$centerScaled.width() * scaleX / (float)2), $this$centerScaled.centerY() + (int)((float)$this$centerScaled.height() * scaleY / (float)2));
    }

    @CheckResult
    @NotNull
    public static final Rect toRect(@NotNull Size $this$toRect) {
        Intrinsics.checkNotNullParameter((Object)$this$toRect, (String)"<this>");
        return new Rect(0, 0, $this$toRect.getWidth(), $this$toRect.getHeight());
    }

    @CheckResult
    @NotNull
    public static final RectF toRectF(@NotNull Size $this$toRectF) {
        Intrinsics.checkNotNullParameter((Object)$this$toRectF, (String)"<this>");
        return new RectF(0.0f, 0.0f, (float)$this$toRectF.getWidth(), (float)$this$toRectF.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Size transpose(@NotNull Size $this$transpose) {
        Intrinsics.checkNotNullParameter((Object)$this$transpose, (String)"<this>");
        return new Size($this$transpose.getHeight(), $this$transpose.getWidth());
    }

    @CheckResult
    @NotNull
    public static final Rect intersectionWith(@NotNull Rect $this$intersectionWith, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$intersectionWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int n = $this$intersectionWith.intersect(rect);
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Given rects do not intersect " + $this$intersectionWith + " <> " + rect;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = $this$intersectionWith.left;
        n2 = rect.left;
        bl = false;
        int n3 = Math.max(n, n2);
        n = $this$intersectionWith.top;
        n2 = rect.top;
        bl = false;
        int n4 = Math.max(n, n2);
        n = $this$intersectionWith.right;
        n2 = rect.right;
        bl = false;
        int n5 = Math.min(n, n2);
        n = $this$intersectionWith.bottom;
        n2 = rect.bottom;
        bl = false;
        return new Rect(n3, n4, n5, Math.min(n, n2));
    }

    @CheckResult
    @NotNull
    public static final Rect move(@NotNull Rect $this$move, int relativeX, int relativeY) {
        Intrinsics.checkNotNullParameter((Object)$this$move, (String)"<this>");
        return new Rect($this$move.left + relativeX, $this$move.top + relativeY, $this$move.right + relativeX, $this$move.bottom + relativeY);
    }

    @CheckResult
    @NotNull
    public static final RectF move(@NotNull RectF $this$move, float relativeX, float relativeY) {
        Intrinsics.checkNotNullParameter((Object)$this$move, (String)"<this>");
        return new RectF($this$move.left + relativeX, $this$move.top + relativeY, $this$move.right + relativeX, $this$move.bottom + relativeY);
    }

    @CheckResult
    @NotNull
    public static final SizeF toSizeF(@NotNull Size $this$toSizeF) {
        Intrinsics.checkNotNullParameter((Object)$this$toSizeF, (String)"<this>");
        return new SizeF((float)$this$toSizeF.getWidth(), (float)$this$toSizeF.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Size toSize(@NotNull SizeF $this$toSize) {
        Intrinsics.checkNotNullParameter((Object)$this$toSize, (String)"<this>");
        return new Size(MathKt.roundToInt((float)$this$toSize.getWidth()), MathKt.roundToInt((float)$this$toSize.getHeight()));
    }

    @CheckResult
    @NotNull
    public static final RectF toRectF(@NotNull Rect $this$toRectF) {
        Intrinsics.checkNotNullParameter((Object)$this$toRectF, (String)"<this>");
        return new RectF((float)$this$toRectF.left, (float)$this$toRectF.top, (float)$this$toRectF.right, (float)$this$toRectF.bottom);
    }

    @CheckResult
    @NotNull
    public static final Rect toRect(@NotNull RectF $this$toRect) {
        Intrinsics.checkNotNullParameter((Object)$this$toRect, (String)"<this>");
        return new Rect(MathKt.roundToInt((float)$this$toRect.left), MathKt.roundToInt((float)$this$toRect.top), MathKt.roundToInt((float)$this$toRect.right), MathKt.roundToInt((float)$this$toRect.bottom));
    }

    @CheckResult
    @NotNull
    public static final RectF projectRegionOfInterest(@NotNull SizeF $this$projectRegionOfInterest, @NotNull SizeF toSize, @NotNull RectF regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toSize, (String)"toSize");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        boolean bl = $this$projectRegionOfInterest.getWidth() > 0.0f && $this$projectRegionOfInterest.getHeight() > 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot project from container with non-positive dimensions";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new RectF(regionOfInterest.left * toSize.getWidth() / $this$projectRegionOfInterest.getWidth(), regionOfInterest.top * toSize.getHeight() / $this$projectRegionOfInterest.getHeight(), regionOfInterest.right * toSize.getWidth() / $this$projectRegionOfInterest.getWidth(), regionOfInterest.bottom * toSize.getHeight() / $this$projectRegionOfInterest.getHeight());
    }

    @CheckResult
    @NotNull
    public static final Rect projectRegionOfInterest(@NotNull Size $this$projectRegionOfInterest, @NotNull Size toSize, @NotNull Rect regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toSize, (String)"toSize");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        return LayoutKt.toRect(LayoutKt.projectRegionOfInterest(LayoutKt.toSizeF($this$projectRegionOfInterest), LayoutKt.toSizeF(toSize), LayoutKt.toRectF(regionOfInterest)));
    }

    @CheckResult
    @NotNull
    public static final RectF projectRegionOfInterest(@NotNull RectF $this$projectRegionOfInterest, @NotNull SizeF toSize, @NotNull RectF regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toSize, (String)"toSize");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        return LayoutKt.projectRegionOfInterest(LayoutKt.size($this$projectRegionOfInterest), toSize, LayoutKt.move(regionOfInterest, -$this$projectRegionOfInterest.left, -$this$projectRegionOfInterest.top));
    }

    @CheckResult
    @NotNull
    public static final Rect projectRegionOfInterest(@NotNull Rect $this$projectRegionOfInterest, @NotNull Size toSize, @NotNull Rect regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toSize, (String)"toSize");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        return LayoutKt.projectRegionOfInterest(LayoutKt.size($this$projectRegionOfInterest), toSize, LayoutKt.move(regionOfInterest, -$this$projectRegionOfInterest.left, -$this$projectRegionOfInterest.top));
    }

    @CheckResult
    @NotNull
    public static final RectF projectRegionOfInterest(@NotNull RectF $this$projectRegionOfInterest, @NotNull RectF toRect, @NotNull RectF regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toRect, (String)"toRect");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        return LayoutKt.move(LayoutKt.projectRegionOfInterest($this$projectRegionOfInterest, LayoutKt.size(toRect), regionOfInterest), toRect.left, toRect.top);
    }

    @CheckResult
    @NotNull
    public static final Rect projectRegionOfInterest(@NotNull Rect $this$projectRegionOfInterest, @NotNull Rect toRect, @NotNull Rect regionOfInterest) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRegionOfInterest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toRect, (String)"toRect");
        Intrinsics.checkNotNullParameter((Object)regionOfInterest, (String)"regionOfInterest");
        return LayoutKt.move(LayoutKt.projectRegionOfInterest($this$projectRegionOfInterest, LayoutKt.size(toRect), regionOfInterest), toRect.left, toRect.top);
    }

    @CheckResult
    @NotNull
    public static final Map<Rect, Rect> resizeRegion(@NotNull Size $this$resizeRegion, @NotNull Rect originalRegion, @NotNull Rect newRegion, @NotNull Size newSize) {
        Intrinsics.checkNotNullParameter((Object)$this$resizeRegion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalRegion, (String)"originalRegion");
        Intrinsics.checkNotNullParameter((Object)newRegion, (String)"newRegion");
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new Rect(0, 0, originalRegion.left, originalRegion.top), (Object)new Rect(0, 0, newRegion.left, newRegion.top)), TuplesKt.to((Object)new Rect(originalRegion.left, 0, originalRegion.right, originalRegion.top), (Object)new Rect(newRegion.left, 0, newRegion.right, newRegion.top)), TuplesKt.to((Object)new Rect(originalRegion.right, 0, $this$resizeRegion.getWidth(), originalRegion.top), (Object)new Rect(newRegion.right, 0, newSize.getWidth(), newRegion.top)), TuplesKt.to((Object)new Rect(0, originalRegion.top, originalRegion.left, originalRegion.bottom), (Object)new Rect(0, newRegion.top, newRegion.left, newRegion.bottom)), TuplesKt.to((Object)new Rect(originalRegion.left, originalRegion.top, originalRegion.right, originalRegion.bottom), (Object)new Rect(newRegion.left, newRegion.top, newRegion.right, newRegion.bottom)), TuplesKt.to((Object)new Rect(originalRegion.right, originalRegion.top, $this$resizeRegion.getWidth(), originalRegion.bottom), (Object)new Rect(newRegion.right, newRegion.top, newSize.getWidth(), newRegion.bottom)), TuplesKt.to((Object)new Rect(0, originalRegion.bottom, originalRegion.left, $this$resizeRegion.getHeight()), (Object)new Rect(0, newRegion.bottom, newRegion.left, newSize.getHeight())), TuplesKt.to((Object)new Rect(originalRegion.left, originalRegion.bottom, originalRegion.right, $this$resizeRegion.getHeight()), (Object)new Rect(newRegion.left, newRegion.bottom, newRegion.right, newSize.getHeight())), TuplesKt.to((Object)new Rect(originalRegion.right, originalRegion.bottom, $this$resizeRegion.getWidth(), $this$resizeRegion.getHeight()), (Object)new Rect(newRegion.right, newRegion.bottom, newSize.getWidth(), newSize.getHeight()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final Size size(@NotNull Rect $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return new Size($this$size.width(), $this$size.height());
    }

    @NotNull
    public static final SizeF size(@NotNull RectF $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return new SizeF($this$size.width(), $this$size.height());
    }

    public static final float aspectRatio(@NotNull Size $this$aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)$this$aspectRatio, (String)"<this>");
        return (float)$this$aspectRatio.getWidth() / (float)$this$aspectRatio.getHeight();
    }

    public static final float aspectRatio(@NotNull SizeF $this$aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)$this$aspectRatio, (String)"<this>");
        return $this$aspectRatio.getWidth() / $this$aspectRatio.getHeight();
    }

    @NotNull
    public static final Size size(@NotNull View $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return new Size($this$size.getWidth(), $this$size.getHeight());
    }
}

