/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Size;
import android.util.TypedValue;
import android.view.View;
import com.getbouncer.scan.ui.DebugDetectionBox;
import com.getbouncer.scan.ui.DebugOverlayKt;
import com.getbouncer.scan.ui.R;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0016\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bR\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getbouncer/scan/ui/DebugOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "boxes", "", "Lcom/getbouncer/scan/ui/DebugDetectionBox;", "paint", "Landroid/graphics/Paint;", "textPaint", "clearBoxes", "", "drawBoxes", "canvas", "Landroid/graphics/Canvas;", "getPaintColor", "", "confidence", "", "onDraw", "setBoxes", "scan-ui_release"})
public final class DebugOverlay
extends View {
    private final Paint paint;
    private final Paint textPaint;
    private Collection<DebugDetectionBox> boxes;

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        if (canvas != null) {
            this.drawBoxes(canvas);
        }
    }

    private final void drawBoxes(Canvas canvas) {
        Collection<DebugDetectionBox> collection = this.boxes;
        if (collection != null) {
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DebugDetectionBox it = (DebugDetectionBox)element$iv;
                boolean bl = false;
                this.paint.setColor(this.getPaintColor(it.getConfidence()));
                this.textPaint.setColor(this.getPaintColor(it.getConfidence()));
                RectF rect = DebugOverlayKt.scaled(it.getRect(), new Size(this.getWidth(), this.getHeight()));
                canvas.drawRect(rect, this.paint);
                canvas.drawText(it.getLabel(), rect.left, rect.bottom, this.textPaint);
            }
        }
    }

    private final int getPaintColor(float confidence) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return context.getResources().getColor((double)confidence > 0.75 ? R.color.bouncerDebugHighConfidence : ((double)confidence > 0.5 ? R.color.bouncerDebugMediumConfidence : R.color.bouncerDebugLowConfidence));
    }

    public final void setBoxes(@Nullable Collection<DebugDetectionBox> boxes) {
        this.boxes = boxes;
        this.invalidate();
        this.requestLayout();
    }

    public final void clearBoxes() {
        this.setBoxes(CollectionsKt.emptyList());
    }

    public DebugOverlay(@NotNull Context context, @Nullable AttributeSet attrs) {
        Paint $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        Paint paint = new Paint(1);
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        DebugOverlay debugOverlay = this;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeWidth(2.0f);
        Unit unit = Unit.INSTANCE;
        debugOverlay.paint = paint;
        paint = new Paint(1);
        bl = false;
        bl2 = false;
        $this$apply = paint;
        debugOverlay = this;
        boolean bl4 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        $this$apply.setTextSize(TypedValue.applyDimension((int)2, (float)20.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        $this$apply.setTextAlign(Paint.Align.LEFT);
        unit = Unit.INSTANCE;
        debugOverlay.textPaint = paint;
    }

    public /* synthetic */ DebugOverlay(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

