/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.getbouncer.scan.ui.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u00020\r2\b\b\u0001\u0010\u001e\u001a\u00020\nH\u0016J\u0014\u0010\u001f\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012 \u0014*\b\u0018\u00010\u0012R\u00020\u00130\u0012R\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/getbouncer/scan/ui/ViewFinderBackground;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "attributes", "Landroid/content/res/TypedArray;", "backgroundColor", "", "onDrawListener", "Lkotlin/Function0;", "", "paintBackground", "Landroid/graphics/Paint;", "paintWindow", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "viewFinderRect", "Landroid/graphics/Rect;", "clearOnDrawListener", "clearViewFinderRect", "getBackgroundLuminance", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setBackgroundColor", "color", "setOnDrawListener", "setViewFinderRect", "scan-ui_release"})
public final class ViewFinderBackground
extends View {
    private Rect viewFinderRect;
    private Function0<Unit> onDrawListener;
    private final Resources.Theme theme;
    private final TypedArray attributes;
    private final int backgroundColor;
    private Paint paintBackground;
    private final Paint paintWindow;

    public final void setViewFinderRect(@NotNull Rect viewFinderRect) {
        Intrinsics.checkNotNullParameter((Object)viewFinderRect, (String)"viewFinderRect");
        this.viewFinderRect = viewFinderRect;
        this.requestLayout();
    }

    public final void clearViewFinderRect() {
        this.viewFinderRect = null;
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.paintBackground.setColor(color2);
        this.requestLayout();
    }

    public final int getBackgroundLuminance() {
        int color2 = this.paintBackground.getColor();
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        return MathKt.roundToInt((float)((0.2126f * r + 0.7152f * g + 0.0722f * b) * 255.0f));
    }

    public final void setOnDrawListener(@NotNull Function0<Unit> onDrawListener) {
        Intrinsics.checkNotNullParameter(onDrawListener, (String)"onDrawListener");
        this.onDrawListener = onDrawListener;
    }

    public final void clearOnDrawListener() {
        this.onDrawListener = null;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Function0<Unit> onDrawListener;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawPaint(this.paintBackground);
        Rect viewFinderRect = this.viewFinderRect;
        if (viewFinderRect != null) {
            canvas.drawRect(viewFinderRect, this.paintWindow);
        }
        if ((onDrawListener = this.onDrawListener) != null) {
            onDrawListener.invoke();
        }
    }

    public ViewFinderBackground(@NotNull Context context, @Nullable AttributeSet attrs) {
        Paint $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.theme = context.getTheme();
        TypedArray typedArray = this.theme.obtainStyledAttributes(attrs, R.styleable.ViewFinderBackground, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"theme.obtainStyledAttrib\u2026ewFinderBackground, 0, 0)");
        this.attributes = typedArray;
        this.backgroundColor = this.attributes.getColor(R.styleable.ViewFinderBackground_backgroundColor, Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.bouncerNotFoundBackground, this.theme) : this.getResources().getColor(R.color.bouncerNotFoundBackground));
        Paint paint = new Paint(1);
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        ViewFinderBackground viewFinderBackground = this;
        boolean bl3 = false;
        $this$apply.setColor(this.backgroundColor);
        $this$apply.setStyle(Paint.Style.FILL);
        Unit unit = Unit.INSTANCE;
        viewFinderBackground.paintBackground = paint;
        paint = new Paint(1);
        bl = false;
        bl2 = false;
        $this$apply = paint;
        viewFinderBackground = this;
        boolean bl4 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        $this$apply.setStyle(Paint.Style.FILL);
        unit = Unit.INSTANCE;
        viewFinderBackground.paintWindow = paint;
        this.setLayerType(2, null);
    }

    public /* synthetic */ ViewFinderBackground(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

