/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.ui.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006\u001a\u0016\u0010\t\u001a\u00020\u0006*\u00020\u00072\b\b\u0001\u0010\n\u001a\u00020\u0006H\u0007\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00072\b\b\u0001\u0010\r\u001a\u00020\u0006\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00072\b\b\u0001\u0010\u0010\u001a\u00020\u0006\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00162\b\b\u0001\u0010\r\u001a\u00020\u0006\u001a\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00182\b\b\u0001\u0010\u0010\u001a\u00020\u0006\u001a\u0012\u0010\u0019\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0014\u001a\n\u0010\u001b\u001a\u00020\u0012*\u00020\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u00162\b\b\u0001\u0010\r\u001a\u00020\u0006\u00a8\u0006\u001d"}, d2={"asRect", "Landroid/graphics/Rect;", "Landroid/view/View;", "centerPoint", "Landroid/graphics/PointF;", "dpToPixels", "", "Landroid/content/Context;", "dp", "getColorByRes", "colorRes", "getDrawableByRes", "Landroid/graphics/drawable/Drawable;", "drawableRes", "getFloatResource", "", "id", "hide", "", "isVisible", "", "setDrawable", "Landroid/widget/ImageView;", "setTextSizeByRes", "Landroid/widget/TextView;", "setVisible", "visible", "show", "startAnimation", "scan-ui_release"})
public final class ViewExtensionsKt {
    public static final boolean isVisible(@NotNull View $this$isVisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"$this$isVisible");
        return $this$isVisible.getVisibility() == 0;
    }

    public static final void setVisible(@NotNull View $this$setVisible, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)$this$setVisible, (String)"$this$setVisible");
        $this$setVisible.setVisibility(visible ? 0 : 8);
    }

    public static final void show(@NotNull View $this$show) {
        Intrinsics.checkNotNullParameter((Object)$this$show, (String)"$this$show");
        ViewExtensionsKt.setVisible($this$show, true);
    }

    public static final void hide(@NotNull View $this$hide) {
        Intrinsics.checkNotNullParameter((Object)$this$hide, (String)"$this$hide");
        ViewExtensionsKt.setVisible($this$hide, false);
    }

    @ColorInt
    public static final int getColorByRes(@NotNull Context $this$getColorByRes, @ColorRes int colorRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorByRes, (String)"$this$getColorByRes");
        return ContextCompat.getColor((Context)$this$getColorByRes, (int)colorRes);
    }

    @Nullable
    public static final Drawable getDrawableByRes(@NotNull Context $this$getDrawableByRes, @DrawableRes int drawableRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableByRes, (String)"$this$getDrawableByRes");
        return ContextCompat.getDrawable((Context)$this$getDrawableByRes, (int)drawableRes);
    }

    public static final void setDrawable(@NotNull ImageView $this$setDrawable, @DrawableRes int drawableRes) {
        Intrinsics.checkNotNullParameter((Object)$this$setDrawable, (String)"$this$setDrawable");
        Context context = $this$setDrawable.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
        $this$setDrawable.setImageDrawable(ViewExtensionsKt.getDrawableByRes(context, drawableRes));
    }

    public static final void startAnimation(@NotNull ImageView $this$startAnimation, @DrawableRes int drawableRes) {
        Intrinsics.checkNotNullParameter((Object)$this$startAnimation, (String)"$this$startAnimation");
        Context context = $this$startAnimation.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
        Drawable d = ViewExtensionsKt.getDrawableByRes(context, drawableRes);
        $this$startAnimation.setImageDrawable(d);
        if (d instanceof Animatable) {
            ((Animatable)d).start();
        }
    }

    @NotNull
    public static final Rect asRect(@NotNull View $this$asRect) {
        Intrinsics.checkNotNullParameter((Object)$this$asRect, (String)"$this$asRect");
        return new Rect($this$asRect.getLeft(), $this$asRect.getTop(), $this$asRect.getRight(), $this$asRect.getBottom());
    }

    public static final int dpToPixels(@NotNull Context $this$dpToPixels, int dp) {
        Intrinsics.checkNotNullParameter((Object)$this$dpToPixels, (String)"$this$dpToPixels");
        float f = dp;
        Resources resources = $this$dpToPixels.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return MathKt.roundToInt((float)(f * resources.getDisplayMetrics().density));
    }

    public static final float getFloatResource(@NotNull Context $this$getFloatResource, @DimenRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$getFloatResource, (String)"$this$getFloatResource");
        TypedValue value = new TypedValue();
        $this$getFloatResource.getResources().getValue(id, value, true);
        if (value.type == 4) {
            return value.getFloat();
        }
        throw (Throwable)new Resources.NotFoundException("Resource ID #0x " + Integer.toHexString(id) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
    }

    public static final void setTextSizeByRes(@NotNull TextView $this$setTextSizeByRes, @DimenRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$setTextSizeByRes, (String)"$this$setTextSizeByRes");
        $this$setTextSizeByRes.setTextSize(0, $this$setTextSizeByRes.getResources().getDimension(id));
    }

    @NotNull
    public static final PointF centerPoint(@NotNull View $this$centerPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$centerPoint, (String)"$this$centerPoint");
        return new PointF((float)$this$centerPoint.getLeft() + (float)$this$centerPoint.getWidth() / 2.0f, (float)$this$centerPoint.getTop() + (float)$this$centerPoint.getHeight() / 2.0f);
    }
}

