/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.scan.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import com.getbouncer.scan.camera.CameraErrorListener;
import com.getbouncer.scan.framework.Config;
import com.getbouncer.scan.ui.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002R\"\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/getbouncer/scan/ui/CameraErrorListenerImpl;", "Lcom/getbouncer/scan/camera/CameraErrorListener;", "context", "Landroid/content/Context;", "callback", "Lkotlin/Function1;", "", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "getContext", "()Landroid/content/Context;", "onCameraAccessError", "cause", "onCameraOpenError", "onCameraUnsupportedError", "showCameraError", "message", "", "scan-ui_release"})
public class CameraErrorListenerImpl
implements CameraErrorListener {
    @NotNull
    private final Context context;
    @NotNull
    private final Function1<Throwable, Unit> callback;

    public CameraErrorListenerImpl(@NotNull Context context, @NotNull Function1<? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.context = context;
        this.callback = callback;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final Function1<Throwable, Unit> getCallback() {
        return this.callback;
    }

    public void onCameraOpenError(@Nullable Throwable cause) {
        this.showCameraError(R.string.bouncer_error_camera_open, cause);
    }

    public void onCameraAccessError(@Nullable Throwable cause) {
        this.showCameraError(R.string.bouncer_error_camera_access, cause);
    }

    public void onCameraUnsupportedError(@Nullable Throwable cause) {
        Log.e((String)Config.INSTANCE.getLogTag(), (String)"Camera not supported", (Throwable)cause);
        this.showCameraError(R.string.bouncer_error_camera_unsupported, cause);
    }

    private final void showCameraError(@StringRes int message, Throwable cause) {
        new AlertDialog.Builder(this.context).setTitle(R.string.bouncer_error_camera_title).setMessage(message).setPositiveButton(R.string.bouncer_error_camera_acknowledge_button, (arg_0, arg_1) -> CameraErrorListenerImpl.showCameraError$lambda-0(this, cause, arg_0, arg_1)).show();
    }

    private static final void showCameraError$lambda-0(CameraErrorListenerImpl this$0, Throwable $cause, DialogInterface $noName_0, int $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCallback().invoke((Object)$cause);
    }
}

