/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http;

import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.HttpSink;
import com.getindata.connectors.http.SchemaLifecycleAwareElementConverter;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.SinkHttpClientBuilder;
import com.getindata.connectors.http.internal.sink.HttpSinkRequestEntry;
import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.sink.httpclient.JavaNetSinkHttpClient;
import com.getindata.connectors.http.internal.table.sink.Slf4jHttpPostRequestCallback;
import com.getindata.connectors.http.internal.utils.HttpHeaderUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.connector.base.sink.writer.ElementConverter;

public class HttpSinkBuilder<InputT>
extends AsyncSinkBaseBuilder<InputT, HttpSinkRequestEntry, HttpSinkBuilder<InputT>> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 500;
    private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 50;
    private static final int DEFAULT_MAX_BUFFERED_REQUESTS = 10000;
    private static final long DEFAULT_MAX_BATCH_SIZE_IN_B = 0x500000L;
    private static final long DEFAULT_MAX_TIME_IN_BUFFER_MS = 5000L;
    private static final long DEFAULT_MAX_RECORD_SIZE_IN_B = 0x100000L;
    private static final SinkHttpClientBuilder DEFAULT_CLIENT_BUILDER = JavaNetSinkHttpClient::new;
    private static final HttpPostRequestCallback<HttpRequest> DEFAULT_POST_REQUEST_CALLBACK = new Slf4jHttpPostRequestCallback();
    private static final HeaderPreprocessor DEFAULT_HEADER_PREPROCESSOR = HttpHeaderUtils.createBasicAuthorizationHeaderPreprocessor();
    private final Properties properties = new Properties();
    private String endpointUrl;
    private ElementConverter<InputT, HttpSinkRequestEntry> elementConverter;
    private SinkHttpClientBuilder sinkHttpClientBuilder = DEFAULT_CLIENT_BUILDER;
    private HttpPostRequestCallback<HttpRequest> httpPostRequestCallback = DEFAULT_POST_REQUEST_CALLBACK;
    private HeaderPreprocessor headerPreprocessor = DEFAULT_HEADER_PREPROCESSOR;

    HttpSinkBuilder() {
    }

    public HttpSinkBuilder<InputT> setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    public HttpSinkBuilder<InputT> setSinkHttpClientBuilder(SinkHttpClientBuilder sinkHttpClientBuilder) {
        this.sinkHttpClientBuilder = sinkHttpClientBuilder;
        return this;
    }

    @Deprecated
    @PublicEvolving
    public HttpSinkBuilder<InputT> setElementConverter(ElementConverter<InputT, HttpSinkRequestEntry> elementConverter) {
        this.elementConverter = elementConverter;
        return this;
    }

    @PublicEvolving
    public HttpSinkBuilder<InputT> setElementConverter(SchemaLifecycleAwareElementConverter<InputT, HttpSinkRequestEntry> elementConverter) {
        this.elementConverter = elementConverter;
        return this;
    }

    public HttpSinkBuilder<InputT> setHttpPostRequestCallback(HttpPostRequestCallback<HttpRequest> httpPostRequestCallback) {
        this.httpPostRequestCallback = httpPostRequestCallback;
        return this;
    }

    public HttpSinkBuilder<InputT> setHttpHeaderPreprocessor(HeaderPreprocessor headerPreprocessor) {
        this.headerPreprocessor = headerPreprocessor;
        return this;
    }

    public HttpSinkBuilder<InputT> setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
        return this;
    }

    public HttpSinkBuilder<InputT> setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public HttpSink<InputT> build() {
        return new HttpSink<InputT>(this.elementConverter, Optional.ofNullable(this.getMaxBatchSize()).orElse(500), Optional.ofNullable(this.getMaxInFlightRequests()).orElse(50), Optional.ofNullable(this.getMaxBufferedRequests()).orElse(10000), Optional.ofNullable(this.getMaxBatchSizeInBytes()).orElse(0x500000L), Optional.ofNullable(this.getMaxTimeInBufferMS()).orElse(5000L), Optional.ofNullable(this.getMaxRecordSizeInBytes()).orElse(0x100000L), this.endpointUrl, this.httpPostRequestCallback, this.headerPreprocessor, this.sinkHttpClientBuilder, this.properties);
    }
}

