/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal;

import com.getindata.connectors.http.internal.HeaderValuePreprocessor;
import java.util.Base64;
import java.util.Objects;

public class BasicAuthHeaderValuePreprocessor
implements HeaderValuePreprocessor {
    public static final String BASIC = "Basic ";
    private boolean useRawAuthHeader = false;

    public BasicAuthHeaderValuePreprocessor() {
        this(false);
    }

    public BasicAuthHeaderValuePreprocessor(boolean useRawAuthHeader) {
        this.useRawAuthHeader = useRawAuthHeader;
    }

    @Override
    public String preprocessHeaderValue(String rawValue) {
        Objects.requireNonNull(rawValue);
        if (this.useRawAuthHeader || rawValue.startsWith(BASIC)) {
            return rawValue;
        }
        return BASIC + Base64.getEncoder().encodeToString(rawValue.getBytes());
    }
}

