/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal;

import com.getindata.connectors.http.internal.HeaderValuePreprocessor;
import com.getindata.connectors.http.internal.auth.OidcAccessTokenManager;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCAuthHeaderValuePreprocessor
implements HeaderValuePreprocessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OIDCAuthHeaderValuePreprocessor.class);
    private final String oidcAuthURL;
    private final String oidcTokenRequest;
    private Duration oidcExpiryReduction = Duration.ofSeconds(1L);

    public OIDCAuthHeaderValuePreprocessor(String oidcAuthURL, String oidcTokenRequest, Optional<Duration> oidcExpiryReduction) {
        this.oidcAuthURL = oidcAuthURL;
        this.oidcTokenRequest = oidcTokenRequest;
        if (oidcExpiryReduction.isPresent()) {
            this.oidcExpiryReduction = oidcExpiryReduction.get();
        }
    }

    @Override
    public String preprocessHeaderValue(String rawValue) {
        OidcAccessTokenManager auth = new OidcAccessTokenManager(HttpClient.newBuilder().build(), this.oidcTokenRequest, this.oidcAuthURL, this.oidcExpiryReduction);
        return "BEARER " + auth.authenticate();
    }
}

