/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.auth;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OidcAccessTokenManager.class);
    private static final Duration DEFAULT_TOKEN_EXPIRATION_REDUCTION = Duration.ofSeconds(1L);
    private final HttpClient httpClient;
    private final String tokenRequest;
    private final String url;
    private final Duration tokenExpirationReduction;
    private String cachedAccessToken;
    private Instant cachedAccessTokenExp;

    public OidcAccessTokenManager(HttpClient httpClient, String tokenRequest, String url) {
        this(httpClient, tokenRequest, url, DEFAULT_TOKEN_EXPIRATION_REDUCTION);
    }

    public OidcAccessTokenManager(HttpClient httpClient, String tokenRequest, String url, Duration tokenExpirationReduction) {
        this.tokenRequest = tokenRequest;
        this.httpClient = httpClient;
        this.url = url;
        this.tokenExpirationReduction = null == tokenExpirationReduction ? DEFAULT_TOKEN_EXPIRATION_REDUCTION : tokenExpirationReduction;
    }

    private void requestAccessToken() {
        try {
            Duration expiresIn;
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.url)).header("Content-Type", "application/x-www-form-urlencoded").method("POST", HttpRequest.BodyPublishers.ofString(this.tokenRequest)).build();
            HttpResponse<byte[]> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
            ObjectMapper objectMapper = new ObjectMapper();
            if (200 == response.statusCode()) {
                byte[] bytes = response.body();
                JsonNode rootNode = objectMapper.readTree(bytes);
                JsonNode tokenNode = rootNode.path("access_token");
                JsonNode expiresInNode = rootNode.path("expires_in");
                this.cachedAccessToken = tokenNode.textValue();
                expiresIn = Duration.ofSeconds(expiresInNode.asInt());
                if (expiresIn.compareTo(this.tokenExpirationReduction) > 0) {
                    expiresIn = expiresIn.minus(this.tokenExpirationReduction);
                }
            } else {
                throw new IllegalStateException("Attempted to get an access token but got http status code " + response.statusCode());
            }
            this.cachedAccessTokenExp = Instant.now().plus(expiresIn);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error found while trying to request a new token");
        }
        catch (IOException e) {
            throw new IllegalStateException("IO Exception occurred", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted Exception occurred", e);
        }
    }

    public String authenticate() {
        if (this.isAccessTokenRequired()) {
            this.requestAccessToken();
        }
        return this.cachedAccessToken;
    }

    private boolean isAccessTokenRequired() {
        return null == this.cachedAccessToken || this.isTokenExpired();
    }

    private boolean isTokenExpired() {
        return Instant.now().isAfter(this.cachedAccessTokenExp);
    }
}

