/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.retry;

import com.getindata.connectors.http.HttpStatusCodeValidationFailedException;
import com.getindata.connectors.http.internal.status.HttpResponseChecker;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.flink.metrics.MetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWithRetry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientWithRetry.class);
    private final HttpClient httpClient;
    private final HttpResponseChecker responseChecker;
    private final Retry retry;

    HttpClientWithRetry(HttpClient httpClient, RetryConfig retryConfig, HttpResponseChecker responseChecker) {
        this.httpClient = httpClient;
        this.responseChecker = responseChecker;
        RetryConfig adjustedRetryConfig = RetryConfig.from(retryConfig).retryExceptions(IOException.class).retryOnResult(this::isTemporalError).build();
        this.retry = Retry.of("http-lookup-connector", adjustedRetryConfig);
    }

    public void registerMetrics(MetricGroup metrics) {
        MetricGroup group = metrics.addGroup("http_lookup_connector");
        group.gauge("successfulCallsWithRetryAttempt", () -> this.retry.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt());
        group.gauge("successfulCallsWithoutRetryAttempt", () -> this.retry.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt());
    }

    public <T> HttpResponse<T> send(Supplier<HttpRequest> requestSupplier, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException, HttpStatusCodeValidationFailedException {
        try {
            HttpResponse response = Retry.decorateCheckedSupplier(this.retry, () -> this.httpClient.send((HttpRequest)requestSupplier.get(), responseBodyHandler)).apply();
            if (!this.responseChecker.isSuccessful(response)) {
                throw new HttpStatusCodeValidationFailedException("Incorrect response code: " + response.statusCode(), response);
            }
            return response;
        }
        catch (HttpStatusCodeValidationFailedException | IOException | InterruptedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected exception", t);
        }
    }

    private boolean isTemporalError(Object response) {
        return this.responseChecker.isTemporalError((HttpResponse)response);
    }

    @Generated
    public static HttpClientWithRetryBuilder builder() {
        return new HttpClientWithRetryBuilder();
    }

    @Generated
    public HttpResponseChecker getResponseChecker() {
        return this.responseChecker;
    }

    @Generated
    public static class HttpClientWithRetryBuilder {
        @Generated
        private HttpClient httpClient;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private HttpResponseChecker responseChecker;

        @Generated
        HttpClientWithRetryBuilder() {
        }

        @Generated
        public HttpClientWithRetryBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public HttpClientWithRetryBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public HttpClientWithRetryBuilder responseChecker(HttpResponseChecker responseChecker) {
            this.responseChecker = responseChecker;
            return this;
        }

        @Generated
        public HttpClientWithRetry build() {
            return new HttpClientWithRetry(this.httpClient, this.retryConfig, this.responseChecker);
        }

        @Generated
        public String toString() {
            return "HttpClientWithRetry.HttpClientWithRetryBuilder(httpClient=" + String.valueOf(this.httpClient) + ", retryConfig=" + String.valueOf(this.retryConfig) + ", responseChecker=" + String.valueOf(this.responseChecker) + ")";
        }
    }
}

