/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.retry;

import com.getindata.connectors.http.internal.retry.RetryStrategyType;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import lombok.Generated;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.source.lookup.LookupOptions;

public class RetryConfigProvider {
    private final ReadableConfig config;

    public static RetryConfig create(ReadableConfig config) {
        return new RetryConfigProvider(config).create();
    }

    private RetryConfig create() {
        return this.createBuilder().maxAttempts((Integer)this.config.get(LookupOptions.MAX_RETRIES) + 1).build();
    }

    private RetryConfig.Builder<?> createBuilder() {
        RetryStrategyType retryStrategy = this.getRetryStrategy();
        if (retryStrategy == RetryStrategyType.FIXED_DELAY) {
            return this.configureFixedDelay();
        }
        if (retryStrategy == RetryStrategyType.EXPONENTIAL_DELAY) {
            return this.configureExponentialDelay();
        }
        throw new IllegalArgumentException("Unsupported retry strategy: " + String.valueOf((Object)retryStrategy));
    }

    private RetryStrategyType getRetryStrategy() {
        return RetryStrategyType.fromCode((String)this.config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_STRATEGY));
    }

    private RetryConfig.Builder<?> configureFixedDelay() {
        return RetryConfig.custom().intervalFunction(IntervalFunction.of((Duration)this.config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_FIXED_DELAY_DELAY)));
    }

    private RetryConfig.Builder<?> configureExponentialDelay() {
        Duration initialDelay = (Duration)this.config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_INITIAL_BACKOFF);
        Duration maxDelay = (Duration)this.config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MAX_BACKOFF);
        Double multiplier = (Double)this.config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MULTIPLIER);
        return RetryConfig.custom().intervalFunction(IntervalFunction.ofExponentialBackoff(initialDelay, (double)multiplier, maxDelay));
    }

    @Generated
    private RetryConfigProvider(ReadableConfig config) {
        this.config = config;
    }
}

