/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityContext.class);
    private static final String JKS_STORE_TYPE = "JKS";
    private static final String X_509_CERTIFICATE_TYPE = "X.509";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private final char[] storePassword;
    private final KeyStore keystore;

    private SecurityContext(KeyStore keystore, char[] storePassword) {
        this.keystore = keystore;
        this.storePassword = storePassword;
    }

    public static SecurityContext create() {
        char[] storePasswordCharArr = UUID.randomUUID().toString().toCharArray();
        try {
            KeyStore keystore = KeyStore.getInstance(JKS_STORE_TYPE);
            keystore.load(null, storePasswordCharArr);
            log.info("Created KeyStore for Http Connector security context.");
            return new SecurityContext(keystore, storePasswordCharArr);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create KeyStore for Http Connector Security Context.", e);
        }
    }

    public static SecurityContext createFromKeyStore(String keyStorePath, char[] storePassword) {
        try {
            log.info("Creating Security Context from keystore " + keyStorePath);
            File file = new File(keyStorePath);
            FileInputStream stream = new FileInputStream(file);
            KeyStore keystore = KeyStore.getInstance(JKS_STORE_TYPE);
            keystore.load(stream, storePassword);
            return new SecurityContext(keystore, storePassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create KeyStore for Http Connector Security Context.", e);
        }
    }

    public SSLContext getSslContext(TrustManager[] trustManagers) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(this.keystore, this.storePassword);
            SSLContext sslCtx = SSLContext.getInstance("TLSv1.2");
            sslCtx.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
            return sslCtx;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TrustManager[] getTrustManagers() {
        try {
            String alg = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(alg);
            trustManagerFactory.init(this.keystore);
            log.info("Created security Trust Managers for Http Connector security context.");
            return trustManagerFactory.getTrustManagers();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to created Trust Managers for Http Connector security context.", e);
        }
    }

    public void addCertToTrustStore(String certPath) {
        log.info("Trying to add certificate to Security Context - " + certPath);
        try (FileInputStream certInputStream = new FileInputStream(certPath);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509_CERTIFICATE_TYPE);
            Certificate certificate = certificateFactory.generateCertificate(certInputStream);
            this.keystore.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            log.info("Certificated added to keyStore ass trusted - " + certPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to add certificate as trusted to Http Connector security context - " + certPath, e);
        }
    }

    public void addMTlsCerts(String publicKeyPath, String privateKeyPath) {
        try {
            byte[] publicData = Files.readAllBytes(Path.of(publicKeyPath, new String[0]));
            byte[] privateData = Files.readAllBytes(Path.of(privateKeyPath, new String[0]));
            byte[] decodedPrivateData = this.decodePrivateData(privateKeyPath, privateData);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509_CERTIFICATE_TYPE);
            Collection<? extends Certificate> chain = certificateFactory.generateCertificates(new ByteArrayInputStream(publicData));
            PrivateKey key = KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(decodedPrivateData));
            this.keystore.setKeyEntry(UUID.randomUUID().toString(), key, this.storePassword, chain.toArray(new Certificate[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to add client private key/public certificate to Http Connector KeyStore. " + String.join((CharSequence)",", privateKeyPath, publicKeyPath), e);
        }
    }

    private byte[] decodePrivateData(String privateKeyPath, byte[] privateData) {
        if (privateKeyPath.endsWith(".pem")) {
            String privateString = new String(privateData, Charset.defaultCharset()).replace(PRIVATE_KEY_HEADER, "").replaceAll("\\R", "").replace(PRIVATE_KEY_FOOTER, "");
            return Base64.getDecoder().decode(privateString);
        }
        return privateData;
    }
}

