/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.sink;

import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.SchemaLifecycleAwareElementConverter;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.SinkHttpClientBuilder;
import com.getindata.connectors.http.internal.config.SinkRequestSubmitMode;
import com.getindata.connectors.http.internal.sink.HttpSinkRequestEntry;
import com.getindata.connectors.http.internal.sink.HttpSinkWriter;
import com.getindata.connectors.http.internal.sink.HttpSinkWriterStateSerializer;
import com.getindata.connectors.http.internal.sink.httpclient.BatchRequestSubmitterFactory;
import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.sink.httpclient.PerRequestRequestSubmitterFactory;
import com.getindata.connectors.http.internal.sink.httpclient.RequestSubmitterFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class HttpSinkInternal<InputT>
extends AsyncSinkBase<InputT, HttpSinkRequestEntry> {
    private final String endpointUrl;
    private final SinkHttpClientBuilder sinkHttpClientBuilder;
    private final HttpPostRequestCallback<HttpRequest> httpPostRequestCallback;
    private final HeaderPreprocessor headerPreprocessor;
    private final Properties properties;

    protected HttpSinkInternal(ElementConverter<InputT, HttpSinkRequestEntry> elementConverter, int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxBatchSizeInBytes, long maxTimeInBufferMS, long maxRecordSizeInBytes, String endpointUrl, HttpPostRequestCallback<HttpRequest> httpPostRequestCallback, HeaderPreprocessor headerPreprocessor, SinkHttpClientBuilder sinkHttpClientBuilder, Properties properties) {
        super(elementConverter, maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBatchSizeInBytes, maxTimeInBufferMS, maxRecordSizeInBytes);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)endpointUrl) ? 1 : 0) != 0, (Object)"The endpoint URL must be set when initializing HTTP Sink.");
        this.endpointUrl = endpointUrl;
        this.httpPostRequestCallback = (HttpPostRequestCallback)Preconditions.checkNotNull(httpPostRequestCallback, (String)"Post request callback must be set when initializing HTTP Sink.");
        this.headerPreprocessor = (HeaderPreprocessor)Preconditions.checkNotNull((Object)headerPreprocessor, (String)"Header Preprocessor must be set when initializing HTTP Sink.");
        this.sinkHttpClientBuilder = (SinkHttpClientBuilder)Preconditions.checkNotNull((Object)sinkHttpClientBuilder, (String)"The HTTP client builder must not be null when initializing HTTP Sink.");
        this.properties = properties;
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<HttpSinkRequestEntry>> createWriter(Sink.InitContext context) throws IOException {
        ElementConverter elementConverter = this.getElementConverter();
        if (elementConverter instanceof SchemaLifecycleAwareElementConverter) {
            ((SchemaLifecycleAwareElementConverter)elementConverter).open(context);
        }
        return new HttpSinkWriter(elementConverter, context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.endpointUrl, this.sinkHttpClientBuilder.build(this.properties, this.httpPostRequestCallback, this.headerPreprocessor, this.getRequestSubmitterFactory()), Collections.emptyList(), this.properties);
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<HttpSinkRequestEntry>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<HttpSinkRequestEntry>> recoveredState) throws IOException {
        return new HttpSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.endpointUrl, this.sinkHttpClientBuilder.build(this.properties, this.httpPostRequestCallback, this.headerPreprocessor, this.getRequestSubmitterFactory()), recoveredState, this.properties);
    }

    public SimpleVersionedSerializer<BufferedRequestState<HttpSinkRequestEntry>> getWriterStateSerializer() {
        return new HttpSinkWriterStateSerializer();
    }

    private RequestSubmitterFactory getRequestSubmitterFactory() {
        if (SinkRequestSubmitMode.SINGLE.getMode().equalsIgnoreCase(this.properties.getProperty("gid.connector.http.sink.writer.request.mode"))) {
            return new PerRequestRequestSubmitterFactory();
        }
        return new BatchRequestSubmitterFactory(this.getMaxBatchSize());
    }
}

