/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.sink.httpclient;

import com.getindata.connectors.http.internal.sink.httpclient.RequestSubmitter;
import com.getindata.connectors.http.internal.utils.ThreadUtils;
import java.net.http.HttpClient;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

public abstract class AbstractRequestSubmitter
implements RequestSubmitter {
    protected static final int HTTP_CLIENT_PUBLISHING_THREAD_POOL_SIZE = 1;
    protected static final String DEFAULT_REQUEST_TIMEOUT_SECONDS = "30";
    protected final ExecutorService publishingThreadPool;
    protected final int httpRequestTimeOutSeconds;
    protected final String[] headersAndValues;
    protected final HttpClient httpClient;

    public AbstractRequestSubmitter(Properties properties, String[] headersAndValues, HttpClient httpClient) {
        this.headersAndValues = headersAndValues;
        this.publishingThreadPool = Executors.newFixedThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("http-sink-client-response-worker", ThreadUtils.LOGGING_EXCEPTION_HANDLER));
        this.httpRequestTimeOutSeconds = Integer.parseInt(properties.getProperty("gid.connector.http.sink.request.timeout", DEFAULT_REQUEST_TIMEOUT_SECONDS));
        this.httpClient = httpClient;
    }
}

