/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.sink.httpclient;

import com.getindata.connectors.http.internal.config.ConfigException;
import com.getindata.connectors.http.internal.sink.httpclient.BatchRequestSubmitter;
import com.getindata.connectors.http.internal.sink.httpclient.RequestSubmitterFactory;
import com.getindata.connectors.http.internal.utils.JavaNetHttpClientFactory;
import com.getindata.connectors.http.internal.utils.ThreadUtils;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

public class BatchRequestSubmitterFactory
implements RequestSubmitterFactory {
    int HTTP_CLIENT_THREAD_POOL_SIZE = 1;
    private final String maxBatchSize;

    public BatchRequestSubmitterFactory(int maxBatchSize) {
        if (maxBatchSize < 1) {
            throw new IllegalArgumentException("Batch Request submitter batch size must be greater than zero.");
        }
        this.maxBatchSize = String.valueOf(maxBatchSize);
    }

    @Override
    public BatchRequestSubmitter createSubmitter(Properties properties, String[] headersAndValues) {
        String batchRequestSize = properties.getProperty("gid.connector.http.sink.request.batch.size");
        if (StringUtils.isNullOrWhitespaceOnly((String)batchRequestSize)) {
            properties.setProperty("gid.connector.http.sink.request.batch.size", this.maxBatchSize);
        } else {
            try {
                int batchSize = Integer.parseInt(batchRequestSize);
                if (batchSize < 1) {
                    throw new ConfigException(String.format("Property %s must be greater than 0 but was: %s", "gid.connector.http.sink.request.batch.size", batchRequestSize));
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigException(String.format("Property %s must be an integer but was: %s", "gid.connector.http.sink.request.batch.size", batchRequestSize), e);
            }
        }
        ExecutorService httpClientExecutor = Executors.newFixedThreadPool(this.HTTP_CLIENT_THREAD_POOL_SIZE, (ThreadFactory)new ExecutorThreadFactory("http-sink-client-batch-request-worker", ThreadUtils.LOGGING_EXCEPTION_HANDLER));
        return new BatchRequestSubmitter(properties, headersAndValues, JavaNetHttpClientFactory.createClient(properties, httpClientExecutor));
    }
}

