/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.sink.httpclient;

import com.getindata.connectors.http.internal.sink.HttpSinkRequestEntry;
import com.getindata.connectors.http.internal.sink.httpclient.AbstractRequestSubmitter;
import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.sink.httpclient.JavaNetHttpResponseWrapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerRequestSubmitter
extends AbstractRequestSubmitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerRequestSubmitter.class);

    public PerRequestSubmitter(Properties properties, String[] headersAndValues, HttpClient httpClient) {
        super(properties, headersAndValues, httpClient);
    }

    @Override
    public List<CompletableFuture<JavaNetHttpResponseWrapper>> submit(String endpointUrl, List<HttpSinkRequestEntry> requestToSubmit) {
        URI endpointUri = URI.create(endpointUrl);
        ArrayList<CompletableFuture<JavaNetHttpResponseWrapper>> responseFutures = new ArrayList<CompletableFuture<JavaNetHttpResponseWrapper>>();
        for (HttpSinkRequestEntry entry : requestToSubmit) {
            HttpRequest httpRequest = this.buildHttpRequest(entry, endpointUri);
            CompletionStage response = ((CompletableFuture)this.httpClient.sendAsync(httpRequest.getHttpRequest(), HttpResponse.BodyHandlers.ofString()).exceptionally(ex -> {
                log.error("Request fatally failed because of an exception", ex);
                return null;
            })).thenApplyAsync(res -> new JavaNetHttpResponseWrapper(httpRequest, (HttpResponse<String>)res), (Executor)this.publishingThreadPool);
            responseFutures.add((CompletableFuture<JavaNetHttpResponseWrapper>)response);
        }
        return responseFutures;
    }

    private HttpRequest buildHttpRequest(HttpSinkRequestEntry requestEntry, URI endpointUri) {
        HttpRequest.Builder requestBuilder = java.net.http.HttpRequest.newBuilder().uri(endpointUri).version(HttpClient.Version.HTTP_1_1).timeout(Duration.ofSeconds(this.httpRequestTimeOutSeconds)).method(requestEntry.method, HttpRequest.BodyPublishers.ofByteArray(requestEntry.element));
        if (this.headersAndValues.length != 0) {
            requestBuilder.headers(this.headersAndValues);
        }
        return new HttpRequest(requestBuilder.build(), List.of(requestEntry.element), requestEntry.method);
    }
}

