/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.status;

import com.getindata.connectors.http.internal.status.HttpResponseCodeType;
import com.getindata.connectors.http.internal.status.HttpStatusCodeChecker;
import com.getindata.connectors.http.internal.status.SingleValueHttpStatusCodeChecker;
import com.getindata.connectors.http.internal.status.TypeStatusCodeChecker;
import com.getindata.connectors.http.internal.status.WhiteListHttpStatusCodeChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class ComposeHttpStatusCodeChecker
implements HttpStatusCodeChecker {
    private static final Set<HttpStatusCodeChecker> DEFAULT_ERROR_CODES = Set.of(new TypeStatusCodeChecker(HttpResponseCodeType.CLIENT_ERROR), new TypeStatusCodeChecker(HttpResponseCodeType.SERVER_ERROR));
    private static final int MIN_HTTP_STATUS_CODE = 100;
    private final Set<WhiteListHttpStatusCodeChecker> excludedCodes;
    private final Set<HttpStatusCodeChecker> errorCodes;

    public ComposeHttpStatusCodeChecker(ComposeHttpStatusCodeCheckerConfig config) {
        this.excludedCodes = this.prepareWhiteList(config);
        this.errorCodes = this.prepareErrorCodes(config);
    }

    @Override
    public boolean isErrorCode(int statusCode) {
        Preconditions.checkArgument((statusCode >= 100 ? 1 : 0) != 0, (Object)String.format("Provided invalid Http status code %s, status code should be equal or bigger than %d.", statusCode, 100));
        boolean isWhiteListed = this.excludedCodes.stream().anyMatch(check -> check.isWhiteListed(statusCode));
        return !isWhiteListed && this.errorCodes.stream().anyMatch(httpStatusCodeChecker -> httpStatusCodeChecker.isErrorCode(statusCode));
    }

    private Set<HttpStatusCodeChecker> prepareErrorCodes(ComposeHttpStatusCodeCheckerConfig config) {
        String errorCodePrefix;
        Properties properties = config.getProperties();
        String errorCodes = properties.getProperty(errorCodePrefix = config.getErrorCodePrefix(), "");
        if (StringUtils.isNullOrWhitespaceOnly((String)errorCodes)) {
            return DEFAULT_ERROR_CODES;
        }
        String[] splitCodes = errorCodes.split(",");
        return this.prepareErrorCodes(splitCodes);
    }

    private Set<HttpStatusCodeChecker> prepareErrorCodes(String[] statusCodes) {
        HashSet<HttpStatusCodeChecker> errorCodes = new HashSet<HttpStatusCodeChecker>();
        for (String sCode : statusCodes) {
            if (StringUtils.isNullOrWhitespaceOnly((String)sCode)) continue;
            String trimCode = sCode.toUpperCase().trim();
            Preconditions.checkArgument((trimCode.length() == 3 ? 1 : 0) != 0, (String)"Status code should contain three characters. Provided [%s]", (Object[])new Object[]{trimCode});
            if (this.isTypeCode(trimCode)) {
                int code = Integer.parseInt(trimCode.replace("X", ""));
                errorCodes.add(new TypeStatusCodeChecker(HttpResponseCodeType.getByCode(code)));
                continue;
            }
            errorCodes.add(new SingleValueHttpStatusCodeChecker(Integer.parseInt(trimCode)));
        }
        return errorCodes.isEmpty() ? DEFAULT_ERROR_CODES : errorCodes;
    }

    private Set<WhiteListHttpStatusCodeChecker> prepareWhiteList(ComposeHttpStatusCodeCheckerConfig config) {
        Properties properties = config.getProperties();
        String whiteListPrefix = config.getWhiteListPrefix();
        return Arrays.stream(properties.getProperty(whiteListPrefix, "").split(",")).filter(sCode -> !StringUtils.isNullOrWhitespaceOnly((String)sCode)).map(String::trim).mapToInt(Integer::parseInt).mapToObj(WhiteListHttpStatusCodeChecker::new).collect(Collectors.toSet());
    }

    private boolean isTypeCode(String code) {
        return code.charAt(1) == 'X' && code.charAt(2) == 'X';
    }

    public static class ComposeHttpStatusCodeCheckerConfig {
        private final String whiteListPrefix;
        private final String errorCodePrefix;
        private final Properties properties;

        @Generated
        public static ComposeHttpStatusCodeCheckerConfigBuilder builder() {
            return new ComposeHttpStatusCodeCheckerConfigBuilder();
        }

        @Generated
        public String getWhiteListPrefix() {
            return this.whiteListPrefix;
        }

        @Generated
        public String getErrorCodePrefix() {
            return this.errorCodePrefix;
        }

        @Generated
        public Properties getProperties() {
            return this.properties;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComposeHttpStatusCodeCheckerConfig)) {
                return false;
            }
            ComposeHttpStatusCodeCheckerConfig other = (ComposeHttpStatusCodeCheckerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$whiteListPrefix = this.getWhiteListPrefix();
            String other$whiteListPrefix = other.getWhiteListPrefix();
            if (this$whiteListPrefix == null ? other$whiteListPrefix != null : !this$whiteListPrefix.equals(other$whiteListPrefix)) {
                return false;
            }
            String this$errorCodePrefix = this.getErrorCodePrefix();
            String other$errorCodePrefix = other.getErrorCodePrefix();
            if (this$errorCodePrefix == null ? other$errorCodePrefix != null : !this$errorCodePrefix.equals(other$errorCodePrefix)) {
                return false;
            }
            Properties this$properties = this.getProperties();
            Properties other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComposeHttpStatusCodeCheckerConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $whiteListPrefix = this.getWhiteListPrefix();
            result = result * 59 + ($whiteListPrefix == null ? 43 : $whiteListPrefix.hashCode());
            String $errorCodePrefix = this.getErrorCodePrefix();
            result = result * 59 + ($errorCodePrefix == null ? 43 : $errorCodePrefix.hashCode());
            Properties $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComposeHttpStatusCodeChecker.ComposeHttpStatusCodeCheckerConfig(whiteListPrefix=" + this.getWhiteListPrefix() + ", errorCodePrefix=" + this.getErrorCodePrefix() + ", properties=" + String.valueOf(this.getProperties()) + ")";
        }

        @Generated
        private ComposeHttpStatusCodeCheckerConfig(String whiteListPrefix, String errorCodePrefix, Properties properties) {
            this.whiteListPrefix = whiteListPrefix;
            this.errorCodePrefix = errorCodePrefix;
            this.properties = properties;
        }

        @Generated
        public static class ComposeHttpStatusCodeCheckerConfigBuilder {
            @Generated
            private String whiteListPrefix;
            @Generated
            private String errorCodePrefix;
            @Generated
            private Properties properties;

            @Generated
            ComposeHttpStatusCodeCheckerConfigBuilder() {
            }

            @Generated
            public ComposeHttpStatusCodeCheckerConfigBuilder whiteListPrefix(String whiteListPrefix) {
                this.whiteListPrefix = whiteListPrefix;
                return this;
            }

            @Generated
            public ComposeHttpStatusCodeCheckerConfigBuilder errorCodePrefix(String errorCodePrefix) {
                this.errorCodePrefix = errorCodePrefix;
                return this;
            }

            @Generated
            public ComposeHttpStatusCodeCheckerConfigBuilder properties(Properties properties) {
                this.properties = properties;
                return this;
            }

            @Generated
            public ComposeHttpStatusCodeCheckerConfig build() {
                return new ComposeHttpStatusCodeCheckerConfig(this.whiteListPrefix, this.errorCodePrefix, this.properties);
            }

            @Generated
            public String toString() {
                return "ComposeHttpStatusCodeChecker.ComposeHttpStatusCodeCheckerConfig.ComposeHttpStatusCodeCheckerConfigBuilder(whiteListPrefix=" + this.whiteListPrefix + ", errorCodePrefix=" + this.errorCodePrefix + ", properties=" + String.valueOf(this.properties) + ")";
            }
        }
    }
}

