/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.status;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.flink.util.ConfigurationException;

public final class HttpCodesParser {
    private static final Pattern CODE_GROUP_EXPRESSION = Pattern.compile("[1-5][xX]{2}");
    private static final String DELIMITER = Pattern.quote(",");
    private static final int HTTP_CODE_MIN = 100;
    private static final int HTTP_CODE_MAX = 599;

    public static Set<Integer> parse(String codesExpression) throws ConfigurationException {
        HashSet<Integer> whitelist = new HashSet<Integer>();
        HashSet<Integer> blacklist = new HashSet<Integer>();
        for (String rawCode : codesExpression.split(DELIMITER)) {
            String code = rawCode.trim();
            if (code.isEmpty()) continue;
            if (code.startsWith("!")) {
                try {
                    blacklist.add(HttpCodesParser.parseHttpCode(code.substring(1)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("Can not parse code " + code);
                }
            }
            try {
                whitelist.add(HttpCodesParser.parseHttpCode(code));
            }
            catch (NumberFormatException e) {
                if (CODE_GROUP_EXPRESSION.matcher(code).matches()) {
                    int firstGroupCode = Integer.parseInt(code.substring(0, 1)) * 100;
                    List groupCodes = IntStream.range(firstGroupCode, firstGroupCode + 100).boxed().collect(Collectors.toList());
                    whitelist.addAll(groupCodes);
                    continue;
                }
                throw new ConfigurationException("Can not parse code " + code);
            }
        }
        whitelist.removeAll(blacklist);
        return Collections.unmodifiableSet(whitelist);
    }

    private static Integer parseHttpCode(String str) throws ConfigurationException {
        int parsed = Integer.parseInt(str);
        if (parsed < 100 || parsed > 599) {
            throw new ConfigurationException(String.format("Http code out of the range [%s]", parsed));
        }
        return parsed;
    }

    @Generated
    private HttpCodesParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

