/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.status;

import com.getindata.connectors.http.internal.status.HttpCodesParser;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.flink.util.ConfigurationException;

public class HttpResponseChecker {
    private final Set<Integer> successCodes;
    private final Set<Integer> temporalErrorCodes;

    HttpResponseChecker(@NonNull String successCodeExpr, @NonNull String temporalErrorCodeExpr) throws ConfigurationException {
        this(HttpCodesParser.parse(successCodeExpr), HttpCodesParser.parse(temporalErrorCodeExpr));
        if (successCodeExpr == null) {
            throw new NullPointerException("successCodeExpr is marked non-null but is null");
        }
        if (temporalErrorCodeExpr == null) {
            throw new NullPointerException("temporalErrorCodeExpr is marked non-null but is null");
        }
    }

    public HttpResponseChecker(@NonNull Set<Integer> successCodes, @NonNull Set<Integer> temporalErrorCodes) throws ConfigurationException {
        if (successCodes == null) {
            throw new NullPointerException("successCodes is marked non-null but is null");
        }
        if (temporalErrorCodes == null) {
            throw new NullPointerException("temporalErrorCodes is marked non-null but is null");
        }
        this.successCodes = successCodes;
        this.temporalErrorCodes = temporalErrorCodes;
        this.validate();
    }

    public boolean isSuccessful(HttpResponse<?> response) {
        return this.isSuccessful(response.statusCode());
    }

    public boolean isSuccessful(int httpStatusCode) {
        return this.successCodes.contains(httpStatusCode);
    }

    public boolean isTemporalError(HttpResponse<?> response) {
        return this.isTemporalError(response.statusCode());
    }

    public boolean isTemporalError(int httpStatusCode) {
        return this.temporalErrorCodes.contains(httpStatusCode);
    }

    private void validate() throws ConfigurationException {
        if (this.successCodes.isEmpty()) {
            throw new ConfigurationException("Success code list can not be empty");
        }
        HashSet<Integer> intersection = new HashSet<Integer>(this.successCodes);
        intersection.retainAll(this.temporalErrorCodes);
        if (!intersection.isEmpty()) {
            throw new ConfigurationException("Http codes " + String.valueOf(intersection) + " can not be used as both success and retry codes");
        }
    }

    @Generated
    public Set<Integer> getSuccessCodes() {
        return this.successCodes;
    }

    @Generated
    public Set<Integer> getTemporalErrorCodes() {
        return this.temporalErrorCodes;
    }
}

