/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.status;

import java.util.HashMap;
import java.util.Map;

public enum HttpResponseCodeType {
    INFO(1),
    SUCCESS(2),
    REDIRECTION(3),
    CLIENT_ERROR(4),
    SERVER_ERROR(5);

    private static final Map<Integer, HttpResponseCodeType> map;
    private final int httpTypeCode;

    private HttpResponseCodeType(int httpTypeCode) {
        this.httpTypeCode = httpTypeCode;
    }

    public static HttpResponseCodeType getByCode(int statusCode) {
        return map.get(statusCode);
    }

    public int getHttpTypeCode() {
        return this.httpTypeCode;
    }

    static {
        map = new HashMap<Integer, HttpResponseCodeType>();
        for (HttpResponseCodeType httpResponseCodeType : HttpResponseCodeType.values()) {
            map.put(httpResponseCodeType.httpTypeCode, httpResponseCodeType);
        }
    }
}

