/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table;

import com.getindata.connectors.http.SchemaLifecycleAwareElementConverter;
import com.getindata.connectors.http.internal.sink.HttpSinkRequestEntry;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.FlinkRuntimeException;

public class SerializationSchemaElementConverter
implements SchemaLifecycleAwareElementConverter<RowData, HttpSinkRequestEntry> {
    private final String insertMethod;
    private final SerializationSchema<RowData> serializationSchema;
    private boolean schemaOpened = false;

    public SerializationSchemaElementConverter(String insertMethod, SerializationSchema<RowData> serializationSchema) {
        this.insertMethod = insertMethod;
        this.serializationSchema = serializationSchema;
    }

    @Override
    public void open(Sink.InitContext context) {
        if (!this.schemaOpened) {
            try {
                this.serializationSchema.open(context.asSerializationSchemaInitializationContext());
                this.schemaOpened = true;
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to initialize serialization schema.", (Throwable)e);
            }
        }
    }

    public HttpSinkRequestEntry apply(RowData rowData, SinkWriter.Context context) {
        return new HttpSinkRequestEntry(this.insertMethod, this.serializationSchema.serialize((Object)rowData));
    }
}

