/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.LookupQueryInfo;
import com.getindata.connectors.http.internal.table.lookup.RequestFactoryBase;
import com.getindata.connectors.http.internal.utils.uri.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRequestFactory
extends RequestFactoryBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetRequestFactory.class);

    public GetRequestFactory(LookupQueryCreator lookupQueryCreator, HeaderPreprocessor headerPreprocessor, HttpLookupConfig options) {
        super(lookupQueryCreator, headerPreprocessor, options);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected HttpRequest.Builder setUpRequestMethod(LookupQueryInfo lookupQueryInfo) {
        return HttpRequest.newBuilder().uri(this.constructGetUri(lookupQueryInfo)).GET().timeout(Duration.ofSeconds(this.httpRequestTimeOutSeconds));
    }

    URI constructGetUri(LookupQueryInfo lookupQueryInfo) {
        StringBuilder resolvedUrl = new StringBuilder(this.baseUrl);
        if (lookupQueryInfo.hasLookupQuery()) {
            resolvedUrl.append(this.baseUrl.contains("?") ? "&" : "?").append(lookupQueryInfo.getLookupQuery());
        }
        resolvedUrl = GetRequestFactory.resolvePathParameters(lookupQueryInfo, resolvedUrl);
        try {
            return new URIBuilder(resolvedUrl.toString()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

