/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.internal.retry.RetryStrategyType;
import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class HttpLookupConnectorOptions {
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The HTTP endpoint URL.");
    public static final ConfigOption<String> URL_ARGS = ConfigOptions.key((String)"url-args").stringType().noDefaultValue().withDescription("The arguments that should be used for HTTP GET Request.");
    public static final ConfigOption<Boolean> ASYNC_POLLING = ConfigOptions.key((String)"asyncPolling").booleanType().defaultValue((Object)false).withDescription("Whether to use Sync and Async polling mechanism");
    public static final ConfigOption<String> LOOKUP_METHOD = ConfigOptions.key((String)"lookup-method").stringType().defaultValue((Object)"GET").withDescription("Method used for REST executed by lookup connector.");
    public static final ConfigOption<String> LOOKUP_QUERY_CREATOR_IDENTIFIER = ConfigOptions.key((String)"gid.connector.http.source.lookup.query-creator").stringType().noDefaultValue();
    public static final ConfigOption<String> LOOKUP_REQUEST_FORMAT = ConfigOptions.key((String)"lookup-request.format").stringType().defaultValue((Object)"json");
    public static final ConfigOption<Boolean> USE_RAW_AUTH_HEADER = ConfigOptions.key((String)"gid.connector.http.source.lookup.use-raw-authorization-header").booleanType().defaultValue((Object)false).withDescription("Whether to use the raw value of Authorization header");
    public static final ConfigOption<String> REQUEST_CALLBACK_IDENTIFIER = ConfigOptions.key((String)"gid.connector.http.source.lookup.request-callback").stringType().defaultValue((Object)"slf4j-lookup-logger");
    public static final ConfigOption<String> SOURCE_LOOKUP_OIDC_AUTH_TOKEN_ENDPOINT_URL = ConfigOptions.key((String)"gid.connector.http.security.oidc.token.endpoint.url").stringType().noDefaultValue().withDescription("OIDC Token endpoint url.");
    public static final ConfigOption<String> SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST = ConfigOptions.key((String)"gid.connector.http.security.oidc.token.request").stringType().noDefaultValue().withDescription("OIDC token request.");
    public static final ConfigOption<Duration> SOURCE_LOOKUP_OIDC_AUTH_TOKEN_EXPIRY_REDUCTION = ConfigOptions.key((String)"gid.connector.http.security.oidc.token.expiry.reduction").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("OIDC authorization access token expiry reduction as a Duration. A new access token is obtained if the token is older than it's expiry time minus this value.");
    public static final ConfigOption<Duration> SOURCE_LOOKUP_CONNECTION_TIMEOUT = ConfigOptions.key((String)"gid.connector.http.source.lookup.connection.timeout").durationType().noDefaultValue().withDescription("Http client connection timeout.");
    public static final ConfigOption<String> SOURCE_LOOKUP_PROXY_HOST = ConfigOptions.key((String)"gid.connector.http.source.lookup.proxy.host").stringType().noDefaultValue().withDescription("Http client proxy host.");
    public static final ConfigOption<Integer> SOURCE_LOOKUP_PROXY_PORT = ConfigOptions.key((String)"gid.connector.http.source.lookup.proxy.port").intType().noDefaultValue().withDescription("Http client proxy port.");
    public static final ConfigOption<String> SOURCE_LOOKUP_PROXY_USERNAME = ConfigOptions.key((String)"gid.connector.http.source.lookup.proxy.username").stringType().noDefaultValue().withDescription("Http client proxy username for authentication.");
    public static final ConfigOption<String> SOURCE_LOOKUP_PROXY_PASSWORD = ConfigOptions.key((String)"gid.connector.http.source.lookup.proxy.password").stringType().noDefaultValue().withDescription("Http client proxy password for authentication.");
    public static final ConfigOption<String> SOURCE_LOOKUP_RETRY_STRATEGY = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-strategy.type").stringType().defaultValue((Object)RetryStrategyType.FIXED_DELAY.getCode()).withDescription("Auto retry strategy type: fixed-delay (default) or exponential-delay.");
    public static final ConfigOption<String> SOURCE_LOOKUP_HTTP_SUCCESS_CODES = ConfigOptions.key((String)"gid.connector.http.source.lookup.success-codes").stringType().defaultValue((Object)"2XX").withDescription("Comma separated http codes considered as success response. Use [1-5]XX for groups and '!' character for excluding.");
    public static final ConfigOption<String> SOURCE_LOOKUP_HTTP_RETRY_CODES = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-codes").stringType().defaultValue((Object)"500,503,504").withDescription("Comma separated http codes considered as transient errors. Use [1-5]XX for groups and '!' character for excluding.");
    public static final ConfigOption<Duration> SOURCE_LOOKUP_RETRY_FIXED_DELAY_DELAY = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-strategy.fixed-delay.delay").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Fixed-delay interval between retries.");
    public static final ConfigOption<Duration> SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_INITIAL_BACKOFF = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-strategy.exponential-delay.initial-backoff").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Exponential-delay initial delay.");
    public static final ConfigOption<Duration> SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MAX_BACKOFF = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-strategy.exponential-delay.max-backoff").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDescription("Exponential-delay maximum delay.");
    public static final ConfigOption<Double> SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MULTIPLIER = ConfigOptions.key((String)"gid.connector.http.source.lookup.retry-strategy.exponential-delay.backoff-multiplier").doubleType().defaultValue((Object)1.5).withDescription("Exponential-delay multiplier.");
    public static final ConfigOption<String> SOURCE_LOOKUP_HTTP_IGNORED_RESPONSE_CODES = ConfigOptions.key((String)"gid.connector.http.source.lookup.ignored-response-codes").stringType().defaultValue((Object)"").withDescription("Comma separated http codes. Content for these responses will be ignored. Use [1-5]XX for groups and '!' character for excluding. Ignored responses togater with `gid.connector.http.source.lookup.success-codes` are considered as successful.");
}

