/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.LookupQueryCreatorFactory;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.PollingClientFactory;
import com.getindata.connectors.http.internal.table.lookup.AsyncHttpTableLookupFunction;
import com.getindata.connectors.http.internal.table.lookup.BodyBasedRequestFactory;
import com.getindata.connectors.http.internal.table.lookup.GetRequestFactory;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupTableSourceFactory;
import com.getindata.connectors.http.internal.table.lookup.HttpTableLookupFunction;
import com.getindata.connectors.http.internal.table.lookup.JavaNetHttpPollingClientFactory;
import com.getindata.connectors.http.internal.table.lookup.LookupRow;
import com.getindata.connectors.http.internal.table.lookup.LookupSchemaEntry;
import com.getindata.connectors.http.internal.table.lookup.RequestFactoryBase;
import com.getindata.connectors.http.internal.table.lookup.RowDataSingleValueLookupSchemaEntry;
import com.getindata.connectors.http.internal.table.lookup.RowTypeLookupSchemaEntry;
import com.getindata.connectors.http.internal.table.lookup.TableSourceHelper;
import com.getindata.connectors.http.internal.utils.HttpHeaderUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.AsyncLookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingAsyncLookupProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.AsyncLookupFunction;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLookupTableSource
implements LookupTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpLookupTableSource.class);
    private DataType physicalRowDataType;
    private final HttpLookupConfig lookupConfig;
    private final DynamicTableFactory.Context dynamicTableFactoryContext;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    @Nullable
    private final LookupCache cache;

    public HttpLookupTableSource(DataType physicalRowDataType, HttpLookupConfig lookupConfig, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DynamicTableFactory.Context dynamicTablecontext, @Nullable LookupCache cache) {
        this.physicalRowDataType = physicalRowDataType;
        this.lookupConfig = lookupConfig;
        this.decodingFormat = decodingFormat;
        this.dynamicTableFactoryContext = dynamicTablecontext;
        this.cache = cache;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.physicalRowDataType = Projection.of((int[][])projectedFields).project(this.physicalRowDataType);
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext lookupContext) {
        log.debug("getLookupRuntimeProvider Entry");
        LookupRow lookupRow = this.extractLookupRow(lookupContext.getKeys());
        DeserializationSchema responseSchemaDecoder = (DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)lookupContext, this.physicalRowDataType);
        LookupQueryCreatorFactory lookupQueryCreatorFactory = (LookupQueryCreatorFactory)FactoryUtil.discoverFactory((ClassLoader)this.dynamicTableFactoryContext.getClassLoader(), LookupQueryCreatorFactory.class, (String)this.lookupConfig.getReadableConfig().getOptional(HttpLookupConnectorOptions.LOOKUP_QUERY_CREATOR_IDENTIFIER).orElse(this.lookupConfig.getLookupMethod().equalsIgnoreCase("GET") ? "generic-get-query" : "generic-json-query"));
        ReadableConfig readableConfig = this.lookupConfig.getReadableConfig();
        LookupQueryCreator lookupQueryCreator = lookupQueryCreatorFactory.createLookupQueryCreator(readableConfig, lookupRow, this.dynamicTableFactoryContext);
        PollingClientFactory<RowData> pollingClientFactory = this.createPollingClientFactory(lookupQueryCreator, this.lookupConfig);
        return this.getLookupRuntimeProvider(lookupRow, (DeserializationSchema<RowData>)responseSchemaDecoder, pollingClientFactory);
    }

    protected LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupRow lookupRow, DeserializationSchema<RowData> responseSchemaDecoder, PollingClientFactory<RowData> pollingClientFactory) {
        HttpTableLookupFunction dataLookupFunction = new HttpTableLookupFunction(pollingClientFactory, responseSchemaDecoder, lookupRow, this.lookupConfig);
        if (this.lookupConfig.isUseAsync()) {
            AsyncHttpTableLookupFunction asyncLookupFunction = new AsyncHttpTableLookupFunction(dataLookupFunction);
            if (this.cache != null) {
                log.info("Using async version of HttpLookupTable with cache.");
                return PartialCachingAsyncLookupProvider.of((AsyncLookupFunction)asyncLookupFunction, (LookupCache)this.cache);
            }
            log.info("Using async version of HttpLookupTable without cache.");
            return AsyncLookupFunctionProvider.of((AsyncLookupFunction)asyncLookupFunction);
        }
        if (this.cache != null) {
            log.info("Using blocking version of HttpLookupTable with cache.");
            return PartialCachingLookupProvider.of((LookupFunction)dataLookupFunction, (LookupCache)this.cache);
        }
        log.info("Using blocking version of HttpLookupTable without cache.");
        return LookupFunctionProvider.of((LookupFunction)dataLookupFunction);
    }

    public DynamicTableSource copy() {
        return new HttpLookupTableSource(this.physicalRowDataType, this.lookupConfig, this.decodingFormat, this.dynamicTableFactoryContext, this.cache);
    }

    public String asSummaryString() {
        return "Http Lookup Table Source";
    }

    public void applyLimit(long limit) {
    }

    public boolean supportsNestedProjection() {
        return true;
    }

    private PollingClientFactory<RowData> createPollingClientFactory(LookupQueryCreator lookupQueryCreator, HttpLookupConfig lookupConfig) {
        HeaderPreprocessor headerPreprocessor = HttpHeaderUtils.createHeaderPreprocessor(lookupConfig.getReadableConfig());
        String lookupMethod = lookupConfig.getLookupMethod();
        RequestFactoryBase requestFactory = lookupMethod.equalsIgnoreCase("GET") ? new GetRequestFactory(lookupQueryCreator, headerPreprocessor, lookupConfig) : new BodyBasedRequestFactory(lookupMethod, lookupQueryCreator, headerPreprocessor, lookupConfig);
        log.info("requestFactory is " + String.valueOf(requestFactory));
        return new JavaNetHttpPollingClientFactory(requestFactory);
    }

    private LookupRow extractLookupRow(int[][] keys) {
        LookupRow lookupRow = new LookupRow();
        List<String> fieldNames = TableSourceHelper.getFieldNames(this.physicalRowDataType.getLogicalType());
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)this.physicalRowDataType.getLogicalType());
        ArrayList<DataTypes.Field> lookupDataTypes = new ArrayList<DataTypes.Field>();
        List physicalRowDataTypes = this.physicalRowDataType.getChildren();
        int i = 0;
        int[][] nArray = keys;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int[] key;
            for (int keyIndex : key = nArray[j]) {
                LogicalType type = (LogicalType)fieldTypes.get(keyIndex);
                String name = fieldNames.get(keyIndex);
                lookupDataTypes.add(DataTypes.FIELD((String)name, (DataType)((DataType)physicalRowDataTypes.get(keyIndex))));
                lookupRow.addLookupEntry(this.extractKeyColumn(name, i++, type));
            }
        }
        lookupRow.setLookupPhysicalRowDataType(HttpLookupTableSourceFactory.row(lookupDataTypes));
        return lookupRow;
    }

    private LookupSchemaEntry<RowData> extractKeyColumn(String name, int parentIndex, LogicalType type) {
        if (type instanceof RowType) {
            RowTypeLookupSchemaEntry rowLookupEntry = new RowTypeLookupSchemaEntry(name, RowData.createFieldGetter((LogicalType)type, (int)parentIndex));
            List fields = ((RowType)type).getFields();
            int index = 0;
            for (RowType.RowField rowField : fields) {
                rowLookupEntry.addLookupEntry(this.processRow(rowField, index++));
            }
            return rowLookupEntry;
        }
        return new RowDataSingleValueLookupSchemaEntry(name, RowData.createFieldGetter((LogicalType)type, (int)parentIndex));
    }

    private LookupSchemaEntry<RowData> processRow(RowType.RowField rowField, int parentIndex) {
        LogicalType type1 = rowField.getType();
        String name = rowField.getName();
        if (type1 instanceof RowType) {
            RowTypeLookupSchemaEntry rowLookupEntry = new RowTypeLookupSchemaEntry(name, RowData.createFieldGetter((LogicalType)type1, (int)parentIndex));
            int index = 0;
            List rowFields = ((RowType)type1).getFields();
            for (RowType.RowField rowField1 : rowFields) {
                rowLookupEntry.addLookupEntry(this.processRow(rowField1, index++));
            }
            return rowLookupEntry;
        }
        return new RowDataSingleValueLookupSchemaEntry(name, RowData.createFieldGetter((LogicalType)type1, (int)parentIndex));
    }
}

