/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.HttpPostRequestCallbackFactory;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupTableSource;
import com.getindata.connectors.http.internal.utils.ConfigUtils;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;

public class HttpLookupTableSourceFactory
implements DynamicTableSourceFactory {
    private static DataTypes.Field columnToField(Column column) {
        return DataTypes.FIELD((String)column.getName(), (DataType)DataTypeUtils.removeTimeAttribute((DataType)column.getDataType()));
    }

    public static DataType row(List<DataTypes.Field> fields) {
        return DataTypes.ROW((DataTypes.Field[])fields.toArray(new DataTypes.Field[0]));
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context dynamicTableContext) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)dynamicTableContext);
        ReadableConfig readable = helper.getOptions();
        helper.validateExcept(new String[]{"table.", "gid.connector.http.", HttpLookupConnectorOptions.LOOKUP_REQUEST_FORMAT.key()});
        this.validateHttpLookupSourceOptions(readable);
        DecodingFormat decodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
        HttpLookupConfig lookupConfig = this.getHttpLookupOptions(dynamicTableContext, readable);
        ResolvedSchema resolvedSchema = dynamicTableContext.getCatalogTable().getResolvedSchema();
        DataType physicalRowDataType = this.toRowDataType(resolvedSchema.getColumns(), Column::isPhysical);
        return new HttpLookupTableSource(physicalRowDataType, lookupConfig, (DecodingFormat<DeserializationSchema<RowData>>)decodingFormat, dynamicTableContext, this.getLookupCache(readable));
    }

    protected void validateHttpLookupSourceOptions(ReadableConfig tableOptions) throws IllegalArgumentException {
        tableOptions.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_ENDPOINT_URL).ifPresent(url -> {
            if (tableOptions.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST).isEmpty()) {
                throw new IllegalArgumentException("Config option " + HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST.key() + " is required, if " + HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_ENDPOINT_URL.key() + " is configured.");
            }
        });
    }

    public String factoryIdentifier() {
        return "rest-lookup";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Set.of(HttpLookupConnectorOptions.URL, FactoryUtil.FORMAT);
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Set.of(HttpLookupConnectorOptions.URL_ARGS, HttpLookupConnectorOptions.ASYNC_POLLING, HttpLookupConnectorOptions.LOOKUP_METHOD, HttpLookupConnectorOptions.REQUEST_CALLBACK_IDENTIFIER, LookupOptions.CACHE_TYPE, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE, LookupOptions.PARTIAL_CACHE_MAX_ROWS, LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY, HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_EXPIRY_REDUCTION, HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST, HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_ENDPOINT_URL, LookupOptions.MAX_RETRIES, HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_STRATEGY, HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_FIXED_DELAY_DELAY, HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_INITIAL_BACKOFF, HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MULTIPLIER, HttpLookupConnectorOptions.SOURCE_LOOKUP_RETRY_EXPONENTIAL_DELAY_MAX_BACKOFF, HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_SUCCESS_CODES, HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_RETRY_CODES, HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_IGNORED_RESPONSE_CODES, HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_HOST, HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_PORT, HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_USERNAME, HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_PASSWORD, HttpLookupConnectorOptions.SOURCE_LOOKUP_CONNECTION_TIMEOUT);
    }

    private HttpLookupConfig getHttpLookupOptions(DynamicTableFactory.Context context, ReadableConfig readableConfig) {
        Properties httpConnectorProperties = ConfigUtils.getHttpConnectorProperties(context.getCatalogTable().getOptions());
        HttpPostRequestCallbackFactory postRequestCallbackFactory = (HttpPostRequestCallbackFactory)FactoryUtil.discoverFactory((ClassLoader)context.getClassLoader(), HttpPostRequestCallbackFactory.class, (String)((String)readableConfig.get(HttpLookupConnectorOptions.REQUEST_CALLBACK_IDENTIFIER)));
        return HttpLookupConfig.builder().lookupMethod((String)readableConfig.get(HttpLookupConnectorOptions.LOOKUP_METHOD)).url((String)readableConfig.get(HttpLookupConnectorOptions.URL)).useAsync((Boolean)readableConfig.get(HttpLookupConnectorOptions.ASYNC_POLLING)).properties(httpConnectorProperties).readableConfig(readableConfig).httpPostRequestCallback(postRequestCallbackFactory.createHttpPostRequestCallback()).build();
    }

    @Nullable
    private LookupCache getLookupCache(ReadableConfig tableOptions) {
        DefaultLookupCache cache = null;
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return cache;
    }

    private DataType toRowDataType(List<Column> columns, Predicate<Column> columnPredicate) {
        return (DataType)columns.stream().filter(columnPredicate).map(HttpLookupTableSourceFactory::columnToField).collect(Collectors.collectingAndThen(Collectors.toList(), HttpLookupTableSourceFactory::row)).notNull();
    }
}

