/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.PollingClient;
import com.getindata.connectors.http.internal.retry.HttpClientWithRetry;
import com.getindata.connectors.http.internal.retry.RetryConfigProvider;
import com.getindata.connectors.http.internal.status.HttpCodesParser;
import com.getindata.connectors.http.internal.status.HttpResponseChecker;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupSourceRequestEntry;
import com.getindata.connectors.http.internal.table.lookup.HttpRequestFactory;
import com.getindata.connectors.http.internal.utils.HttpHeaderUtils;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaNetHttpPollingClient
implements PollingClient<RowData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaNetHttpPollingClient.class);
    private static final String RESULT_TYPE_SINGLE_VALUE = "single-value";
    private static final String RESULT_TYPE_ARRAY = "array";
    private final HttpClientWithRetry httpClient;
    private final DeserializationSchema<RowData> responseBodyDecoder;
    private final HttpRequestFactory requestFactory;
    private final ObjectMapper objectMapper;
    private final HttpPostRequestCallback<HttpLookupSourceRequestEntry> httpPostRequestCallback;
    private final HttpLookupConfig options;
    private final Set<Integer> ignoredErrorCodes;

    public JavaNetHttpPollingClient(HttpClient httpClient, DeserializationSchema<RowData> responseBodyDecoder, HttpLookupConfig options, HttpRequestFactory requestFactory) throws ConfigurationException {
        this.responseBodyDecoder = responseBodyDecoder;
        this.requestFactory = requestFactory;
        this.objectMapper = new ObjectMapper();
        this.httpPostRequestCallback = options.getHttpPostRequestCallback();
        this.options = options;
        ReadableConfig config = options.getReadableConfig();
        this.ignoredErrorCodes = HttpCodesParser.parse((String)config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_IGNORED_RESPONSE_CODES));
        Set<Integer> errorCodes = HttpCodesParser.parse((String)config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_RETRY_CODES));
        HashSet<Integer> successCodes = new HashSet<Integer>();
        successCodes.addAll(HttpCodesParser.parse((String)config.get(HttpLookupConnectorOptions.SOURCE_LOOKUP_HTTP_SUCCESS_CODES)));
        successCodes.addAll(this.ignoredErrorCodes);
        this.httpClient = HttpClientWithRetry.builder().httpClient(httpClient).retryConfig(RetryConfigProvider.create(config)).responseChecker(new HttpResponseChecker(successCodes, errorCodes)).build();
    }

    @Override
    public void open(FunctionContext context) {
        this.httpClient.registerMetrics(context.getMetricGroup());
    }

    @Override
    public Collection<RowData> pull(RowData lookupRow) {
        if (lookupRow == null) {
            return Collections.emptyList();
        }
        try {
            log.debug("Collection<RowData> pull with Rowdata={}.", (Object)lookupRow);
            return this.queryAndProcess(lookupRow);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during HTTP request", e);
        }
    }

    private Collection<RowData> queryAndProcess(RowData lookupData) throws Exception {
        HttpLookupSourceRequestEntry request = this.requestFactory.buildLookupRequest(lookupData);
        HeaderPreprocessor oidcProcessor = HttpHeaderUtils.createOIDCHeaderPreprocessor(this.options.getReadableConfig());
        HttpResponse<String> response = this.httpClient.send(() -> this.updateHttpRequestIfRequired(request, oidcProcessor), HttpResponse.BodyHandlers.ofString());
        return this.processHttpResponse(response, request);
    }

    protected HttpRequest updateHttpRequestIfRequired(HttpLookupSourceRequestEntry request, HeaderPreprocessor oidcHeaderPreProcessor) {
        HttpRequest httpRequest = request.getHttpRequest();
        ReadableConfig readableConfig = this.options.getReadableConfig();
        if (oidcHeaderPreProcessor != null) {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(httpRequest.uri());
            if (httpRequest.timeout().isPresent()) {
                builder.timeout(httpRequest.timeout().get());
            }
            if (httpRequest.method().endsWith("GET")) {
                builder.GET();
            } else {
                builder.method(httpRequest.method(), httpRequest.bodyPublisher().get());
            }
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (httpRequest.headers() != null && !httpRequest.headers().map().isEmpty()) {
                for (Map.Entry<String, List<String>> header : httpRequest.headers().map().entrySet()) {
                    List<String> values = header.getValue();
                    if (values.size() != 1) continue;
                    headerMap.put(header.getKey(), header.getValue().get(0));
                }
            }
            Optional oidcTokenRequest = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST);
            String bearerToken = oidcHeaderPreProcessor.preprocessValueForHeader("Authorization", (String)oidcTokenRequest.get());
            headerMap.put("Authorization", bearerToken);
            String[] headerAndValueArray = HttpHeaderUtils.toHeaderAndValueArray(headerMap);
            builder.headers(headerAndValueArray);
            httpRequest = builder.build();
        }
        return httpRequest;
    }

    private Collection<RowData> processHttpResponse(HttpResponse<String> response, HttpLookupSourceRequestEntry request) throws IOException {
        this.httpPostRequestCallback.call(response, request, "endpoint", Collections.emptyMap());
        String responseBody = response.body();
        log.debug("Received status code [{}] for RestTableSource request with Server response body [{}] ", (Object)response.statusCode(), (Object)responseBody);
        if (StringUtils.isNullOrWhitespaceOnly((String)responseBody) || this.ignoreResponse(response)) {
            return Collections.emptyList();
        }
        return this.deserialize(responseBody);
    }

    @VisibleForTesting
    HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    private Collection<RowData> deserialize(String responseBody) throws IOException {
        byte[] rawBytes = responseBody.getBytes();
        String resultType = this.options.getProperties().getProperty("gid.connector.http.source.lookup.result-type", RESULT_TYPE_SINGLE_VALUE);
        if (resultType.equals(RESULT_TYPE_SINGLE_VALUE)) {
            return this.deserializeSingleValue(rawBytes);
        }
        if (resultType.equals(RESULT_TYPE_ARRAY)) {
            return this.deserializeArray(rawBytes);
        }
        throw new IllegalStateException(String.format("Unknown lookup source result type '%s'.", resultType));
    }

    private List<RowData> deserializeSingleValue(byte[] rawBytes) throws IOException {
        return Optional.ofNullable((RowData)this.responseBodyDecoder.deserialize(rawBytes)).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private List<RowData> deserializeArray(byte[] rawBytes) throws IOException {
        List<JsonNode> rawObjects = this.objectMapper.readValue(rawBytes, new TypeReference<List<JsonNode>>(){});
        ArrayList<RowData> result = new ArrayList<RowData>();
        for (JsonNode rawObject : rawObjects) {
            RowData deserialized;
            if (rawObject instanceof NullNode || (deserialized = (RowData)this.responseBodyDecoder.deserialize(rawObject.toString().getBytes())) == null) continue;
            result.add(deserialized);
        }
        return result;
    }

    private boolean ignoreResponse(HttpResponse<?> response) {
        return this.ignoredErrorCodes.contains(response.statusCode());
    }
}

