/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.internal.utils.uri.NameValuePair;
import com.getindata.connectors.http.internal.utils.uri.URLEncodedUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class LookupQueryInfo
implements Serializable {
    private final String lookupQuery;
    private final Map<String, String> bodyBasedUrlQueryParams;
    private final Map<String, String> pathBasedUrlParams;

    public LookupQueryInfo(String lookupQuery) {
        this(lookupQuery, null, null);
    }

    public LookupQueryInfo(String lookupQuery, Map<String, String> bodyBasedUrlQueryParams, Map<String, String> pathBasedUrlParams) {
        this.lookupQuery = lookupQuery == null ? "" : lookupQuery;
        this.bodyBasedUrlQueryParams = bodyBasedUrlQueryParams == null ? Collections.emptyMap() : bodyBasedUrlQueryParams;
        this.pathBasedUrlParams = pathBasedUrlParams == null ? Collections.emptyMap() : pathBasedUrlParams;
    }

    public String getBodyBasedUrlQueryParameters() {
        return URLEncodedUtils.format(this.bodyBasedUrlQueryParams.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> new NameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()), StandardCharsets.UTF_8);
    }

    public Map<String, String> getPathBasedUrlParameters() {
        return this.pathBasedUrlParams;
    }

    public boolean hasLookupQuery() {
        return !this.lookupQuery.isBlank();
    }

    public boolean hasBodyBasedUrlQueryParameters() {
        return !this.bodyBasedUrlQueryParams.isEmpty();
    }

    public boolean hasPathBasedUrlParameters() {
        return !this.pathBasedUrlParams.isEmpty();
    }

    @Generated
    public String toString() {
        return "LookupQueryInfo(lookupQuery=" + this.getLookupQuery() + ", bodyBasedUrlQueryParams=" + String.valueOf(this.bodyBasedUrlQueryParams) + ", pathBasedUrlParams=" + String.valueOf(this.pathBasedUrlParams) + ")";
    }

    @Generated
    public String getLookupQuery() {
        return this.lookupQuery;
    }
}

