/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupSourceRequestEntry;
import com.getindata.connectors.http.internal.table.lookup.HttpRequestFactory;
import com.getindata.connectors.http.internal.table.lookup.LookupQueryInfo;
import com.getindata.connectors.http.internal.utils.HttpHeaderUtils;
import java.net.http.HttpRequest;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestFactoryBase
implements HttpRequestFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestFactoryBase.class);
    public static final String DEFAULT_REQUEST_TIMEOUT_SECONDS = "30";
    protected final String baseUrl;
    protected final LookupQueryCreator lookupQueryCreator;
    protected final int httpRequestTimeOutSeconds;
    private final String[] headersAndValues;
    private final HttpLookupConfig options;

    public RequestFactoryBase(LookupQueryCreator lookupQueryCreator, HeaderPreprocessor headerPreprocessor, HttpLookupConfig options) {
        this.baseUrl = options.getUrl();
        this.lookupQueryCreator = lookupQueryCreator;
        this.options = options;
        Map<String, String> headerMap = HttpHeaderUtils.prepareHeaderMap("gid.connector.http.source.lookup.header.", options.getProperties(), headerPreprocessor);
        this.headersAndValues = HttpHeaderUtils.toHeaderAndValueArray(headerMap);
        log.debug("RequestFactoryBase headersAndValues: " + Arrays.stream(this.headersAndValues).map(Object::toString).collect(Collectors.joining(",")));
        this.httpRequestTimeOutSeconds = Integer.parseInt(options.getProperties().getProperty("gid.connector.http.source.lookup.request.timeout", DEFAULT_REQUEST_TIMEOUT_SECONDS));
    }

    @Override
    public HttpLookupSourceRequestEntry buildLookupRequest(RowData lookupRow) {
        LookupQueryInfo lookupQueryInfo = this.lookupQueryCreator.createLookupQuery(lookupRow);
        this.getLogger().debug("Created Http lookup query: " + String.valueOf(lookupQueryInfo));
        HttpRequest.Builder requestBuilder = this.setUpRequestMethod(lookupQueryInfo);
        if (this.headersAndValues.length != 0) {
            requestBuilder.headers(this.headersAndValues);
        }
        return new HttpLookupSourceRequestEntry(requestBuilder.build(), lookupQueryInfo);
    }

    protected abstract Logger getLogger();

    protected abstract HttpRequest.Builder setUpRequestMethod(LookupQueryInfo var1);

    protected static StringBuilder resolvePathParameters(LookupQueryInfo lookupQueryInfo, StringBuilder resolvedUrl) {
        if (lookupQueryInfo.hasPathBasedUrlParameters()) {
            for (Map.Entry<String, String> entry : lookupQueryInfo.getPathBasedUrlParameters().entrySet()) {
                String pathParam = "{" + entry.getKey() + "}";
                int startIndex = resolvedUrl.indexOf(pathParam);
                if (startIndex == -1) {
                    throw new FlinkRuntimeException("Unexpected error while parsing the URL for path parameters.");
                }
                int endIndex = startIndex + pathParam.length();
                resolvedUrl = resolvedUrl.replace(startIndex, endIndex, entry.getValue());
            }
        }
        return resolvedUrl;
    }

    @VisibleForTesting
    String[] getHeadersAndValues() {
        return Arrays.copyOf(this.headersAndValues, this.headersAndValues.length);
    }
}

