/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.LookupArg;
import com.getindata.connectors.http.internal.table.lookup.RowDataLookupSchemaEntryBase;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataSingleValueLookupSchemaEntry
extends RowDataLookupSchemaEntryBase<RowData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RowDataSingleValueLookupSchemaEntry.class);

    public RowDataSingleValueLookupSchemaEntry(String fieldName, RowData.FieldGetter fieldGetter) {
        super(fieldName, fieldGetter);
    }

    @Override
    public List<LookupArg> convertToLookupArg(RowData lookupKeyRow) {
        Object value = this.tryGetValue(lookupKeyRow);
        if (value == null) {
            return Collections.emptyList();
        }
        if (!(value instanceof BinaryStringData)) {
            log.debug("Unsupported Key Type {}. Trying simple toString().", value.getClass());
        }
        return Collections.singletonList(new LookupArg(this.getFieldName(), value.toString()));
    }

    private Object tryGetValue(RowData lookupKeyRow) {
        try {
            return this.fieldGetter.getFieldOrNull(lookupKeyRow);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Class cast exception on field getter for field " + this.getFieldName(), e);
        }
    }

    @Generated
    public String toString() {
        return "RowDataSingleValueLookupSchemaEntry{fieldName='" + this.fieldName + "', fieldGetter=" + String.valueOf(this.fieldGetter) + "}";
    }
}

