/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup;

import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupSourceRequestEntry;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JHttpLookupPostRequestCallback
implements HttpPostRequestCallback<HttpLookupSourceRequestEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Slf4JHttpLookupPostRequestCallback.class);

    @Override
    public void call(HttpResponse<String> response, HttpLookupSourceRequestEntry requestEntry, String endpointUrl, Map<String, String> headerMap) {
        HttpRequest httpRequest = requestEntry.getHttpRequest();
        StringJoiner headers = new StringJoiner(";");
        for (Map.Entry<String, List<String>> reqHeaders : httpRequest.headers().map().entrySet()) {
            StringJoiner values = new StringJoiner(";");
            for (String value : reqHeaders.getValue()) {
                values.add(value);
            }
            String header = reqHeaders.getKey() + ": [" + String.valueOf(values) + "]";
            headers.add(header);
        }
        if (response == null) {
            log.warn("Null Http response for request " + httpRequest.uri().toString());
            log.info("Got response for a request.\n  Request:\n    URL: {}\n    Method: {}\n    Headers: {}\n    Params/Body: {}\nResponse: null", new Object[]{httpRequest.uri().toString(), httpRequest.method(), headers, requestEntry.getLookupQueryInfo()});
        } else {
            log.info("Got response for a request.\n  Request:\n    URL: {}\n    Method: {}\n    Headers: {}\n    Params/Body: {}\nResponse: {}\n    Body: {}", new Object[]{httpRequest.uri().toString(), httpRequest.method(), headers, requestEntry.getLookupQueryInfo(), response, response.body().replaceAll("\\R", "")});
        }
    }
}

