/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup.querycreators;

import com.getindata.connectors.http.LookupArg;
import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.internal.table.lookup.LookupQueryInfo;
import com.getindata.connectors.http.internal.table.lookup.LookupRow;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.flink.table.data.RowData;

public class ElasticSearchLiteQueryCreator
implements LookupQueryCreator {
    private static final String ENCODED_SPACE = "%20";
    private static final String ENCODED_QUOTATION_MARK = "%22";
    private final LookupRow lookupRow;

    public ElasticSearchLiteQueryCreator(LookupRow lookupRow) {
        this.lookupRow = lookupRow;
    }

    private static String processLookupArg(LookupArg arg) {
        return arg.getArgName() + ":%22" + arg.getArgValue() + ENCODED_QUOTATION_MARK;
    }

    @Override
    public LookupQueryInfo createLookupQuery(RowData lookupDataRow) {
        Collection<LookupArg> lookupArgs = this.lookupRow.convertToLookupArgs(lookupDataRow);
        String luceneQuery = lookupArgs.stream().map(ElasticSearchLiteQueryCreator::processLookupArg).collect(Collectors.joining("%20AND%20"));
        Object lookupQuery = luceneQuery.isEmpty() ? "" : "q=" + luceneQuery;
        return new LookupQueryInfo((String)lookupQuery);
    }
}

