/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup.querycreators;

import com.getindata.connectors.http.LookupArg;
import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.internal.table.lookup.LookupQueryInfo;
import com.getindata.connectors.http.internal.table.lookup.LookupRow;
import com.getindata.connectors.http.internal.table.lookup.querycreators.ObjectMapperAdapter;
import com.getindata.connectors.http.internal.utils.SerializationSchemaUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJsonAndUrlQueryCreator
implements LookupQueryCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericJsonAndUrlQueryCreator.class);
    private static final long serialVersionUID = 1L;
    private SerializationSchema<RowData> serializationSchema;
    private boolean schemaOpened = false;
    private LookupRow lookupRow;
    private final String httpMethod;
    private final List<String> requestQueryParamsFields;
    private final List<String> requestBodyFields;
    private final Map<String, String> requestUrlMap;

    public GenericJsonAndUrlQueryCreator(String httpMethod, SerializationSchema<RowData> serializationSchema, List<String> requestQueryParamsFields, List<String> requestBodyFields, Map<String, String> requestUrlMap, LookupRow lookupRow) {
        this.httpMethod = httpMethod;
        this.serializationSchema = serializationSchema;
        this.lookupRow = lookupRow;
        this.requestQueryParamsFields = requestQueryParamsFields;
        this.requestBodyFields = requestBodyFields;
        this.requestUrlMap = requestUrlMap;
    }

    @VisibleForTesting
    void setSerializationSchema(SerializationSchema<RowData> serializationSchema) {
        this.serializationSchema = serializationSchema;
    }

    @Override
    public LookupQueryInfo createLookupQuery(RowData lookupDataRow) {
        String lookupQuery;
        ObjectNode jsonObject;
        this.checkOpened();
        HashMap<String, String> bodyBasedUrlQueryParams = new HashMap();
        Collection<LookupArg> lookupArgs = this.lookupRow.convertToLookupArgs(lookupDataRow);
        try {
            jsonObject = (ObjectNode)ObjectMapperAdapter.instance().readTree(this.serializationSchema.serialize((Object)lookupDataRow));
        }
        catch (IOException e) {
            String message = "Unable to parse the lookup arguments to json.";
            log.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        ObjectNode jsonObjectForQueryParams = ObjectMapperAdapter.instance().createObjectNode();
        for (String requestColumnName : this.requestQueryParamsFields) {
            jsonObjectForQueryParams.set(requestColumnName, jsonObject.get(requestColumnName));
        }
        if (this.httpMethod.equalsIgnoreCase("GET")) {
            lookupQuery = GenericJsonAndUrlQueryCreator.convertToQueryParameters(jsonObjectForQueryParams, StandardCharsets.UTF_8.toString());
        } else {
            try {
                lookupQuery = ObjectMapperAdapter.instance().writeValueAsString((Object)jsonObject.retain(this.requestBodyFields));
            }
            catch (JsonProcessingException e) {
                String message = "Unable to convert Json Object to a string";
                throw new RuntimeException("Unable to convert Json Object to a string", e);
            }
            bodyBasedUrlQueryParams = this.createBodyBasedParams(lookupArgs, jsonObjectForQueryParams);
        }
        Map<String, String> pathBasedUrlParams = this.createPathBasedParams(lookupArgs, this.requestUrlMap);
        return new LookupQueryInfo(lookupQuery, bodyBasedUrlQueryParams, pathBasedUrlParams);
    }

    @VisibleForTesting
    static Row rowDataToRow(RowData lookupRowData, DataType rowType) {
        Preconditions.checkNotNull((Object)lookupRowData);
        Preconditions.checkNotNull((Object)rowType);
        Row row = Row.withNames();
        List rowFields = FieldsDataType.getFields((DataType)rowType);
        for (int idx = 0; idx < rowFields.size(); ++idx) {
            String fieldName = ((DataTypes.Field)rowFields.get(idx)).getName();
            Object fieldValue = ((GenericRowData)lookupRowData).getField(idx);
            row.setField(fieldName, fieldValue);
        }
        return row;
    }

    private Map<String, String> createBodyBasedParams(Collection<LookupArg> args, ObjectNode objectNode) {
        LinkedHashMap<String, String> mapOfJsonKeyToLookupArg = new LinkedHashMap<String, String>();
        Iterator iterator = objectNode.fields();
        iterator.forEachRemaining(field -> {
            for (LookupArg arg : args) {
                if (!arg.getArgName().equals(field.getKey())) continue;
                String keyForMap = (String)field.getKey();
                mapOfJsonKeyToLookupArg.put(keyForMap, arg.getArgValue());
            }
        });
        return mapOfJsonKeyToLookupArg;
    }

    private Map<String, String> createPathBasedParams(Collection<LookupArg> args, Map<String, String> urlMap) {
        LinkedHashMap<String, String> mapOfJsonKeyToLookupArg = new LinkedHashMap<String, String>();
        if (urlMap != null) {
            for (String key : urlMap.keySet()) {
                for (LookupArg arg : args) {
                    if (!arg.getArgName().equals(key)) continue;
                    mapOfJsonKeyToLookupArg.put(urlMap.get(key), arg.getArgValue());
                }
            }
        }
        return mapOfJsonKeyToLookupArg;
    }

    @VisibleForTesting
    static String convertToQueryParameters(ObjectNode jsonObject, String enc) {
        Preconditions.checkNotNull((Object)jsonObject);
        StringJoiner result = new StringJoiner("&");
        jsonObject.fields().forEachRemaining(field -> {
            String fieldName = (String)field.getKey();
            String fieldValue = ((JsonNode)field.getValue()).asText();
            try {
                result.add(fieldName + "=" + URLEncoder.encode(fieldValue, enc));
            }
            catch (UnsupportedEncodingException e) {
                String message = "Failed to encode the value of the query parameter name " + fieldName + ": " + fieldValue;
                throw new RuntimeException(message, e);
            }
        });
        return result.toString();
    }

    private void checkOpened() {
        if (!this.schemaOpened) {
            try {
                this.serializationSchema.open(SerializationSchemaUtils.createSerializationInitContext(GenericJsonAndUrlQueryCreator.class));
                this.schemaOpened = true;
            }
            catch (Exception e) {
                String message = "Failed to initialize serialization schema for " + String.valueOf(GenericJsonAndUrlQueryCreator.class);
                log.error(message, (Throwable)e);
                throw new FlinkRuntimeException(message, (Throwable)e);
            }
        }
    }
}

