/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup.querycreators;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.LookupQueryCreatorFactory;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.table.lookup.LookupRow;
import com.getindata.connectors.http.internal.table.lookup.querycreators.GenericJsonAndUrlQueryCreator;
import com.getindata.connectors.http.internal.table.lookup.querycreators.QueryFormatAwareConfiguration;
import com.getindata.connectors.http.internal.utils.SynchronizedSerializationSchema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

public class GenericJsonAndUrlQueryCreatorFactory
implements LookupQueryCreatorFactory {
    private static final long serialVersionUID = 1L;
    public static final String ID = "generic-json-url";
    public static final ConfigOption<List<String>> REQUEST_QUERY_PARAM_FIELDS = ConfigOptions.key((String)"gid.connector.http.request.query-param-fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("The names of the fields that will be mapped to query parameters. The parameters are separated by semicolons, such as 'param1;param2'.");
    public static final ConfigOption<List<String>> REQUEST_BODY_FIELDS = ConfigOptions.key((String)"gid.connector.http.request.body-fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("The names of the fields that will be mapped to the body. The parameters are separated by semicolons, such as 'param1;param2'.");
    public static final ConfigOption<Map<String, String>> REQUEST_URL_MAP = ConfigOptions.key((String)"gid.connector.http.request.url-map").mapType().noDefaultValue().withDescription("The map of insert names to column names usedas url segments. Parses a string as a map of strings. <br>For example if there are table columns called customerId and orderId, then specifying value customerId:cid1,orderID:oid and a url of https://myendpoint/customers/{cid}/orders/{oid} will mean that the url used for the lookup query will dynamically pickup the values for customerId, orderId and use them in the url.<br>Notes<br>The expected format of the map is:<br> key1:value1,key2:value2");

    @Override
    public LookupQueryCreator createLookupQueryCreator(ReadableConfig readableConfig, LookupRow lookupRow, DynamicTableFactory.Context dynamicTableFactoryContext) {
        String httpMethod = (String)readableConfig.get(HttpLookupConnectorOptions.LOOKUP_METHOD);
        String formatIdentifier = (String)readableConfig.get(HttpLookupConnectorOptions.LOOKUP_REQUEST_FORMAT);
        List requestQueryParamsFields = (List)readableConfig.get(REQUEST_QUERY_PARAM_FIELDS);
        List requestBodyFields = (List)readableConfig.get(REQUEST_BODY_FIELDS);
        Map requestUrlMap = (Map)readableConfig.get(REQUEST_URL_MAP);
        SerializationFormatFactory jsonFormatFactory = (SerializationFormatFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), SerializationFormatFactory.class, (String)formatIdentifier);
        QueryFormatAwareConfiguration queryFormatAwareConfiguration = new QueryFormatAwareConfiguration(HttpLookupConnectorOptions.LOOKUP_REQUEST_FORMAT.key() + "." + formatIdentifier, (Configuration)readableConfig);
        EncodingFormat encoder = jsonFormatFactory.createEncodingFormat(dynamicTableFactoryContext, (ReadableConfig)queryFormatAwareConfiguration);
        SynchronizedSerializationSchema<RowData> jsonSerializationSchema = (Boolean)readableConfig.get(HttpLookupConnectorOptions.ASYNC_POLLING) != false ? new SynchronizedSerializationSchema<RowData>((SerializationSchema)encoder.createRuntimeEncoder(null, lookupRow.getLookupPhysicalRowDataType())) : (SynchronizedSerializationSchema<RowData>)encoder.createRuntimeEncoder(null, lookupRow.getLookupPhysicalRowDataType());
        return new GenericJsonAndUrlQueryCreator(httpMethod, jsonSerializationSchema, requestQueryParamsFields, requestBodyFields, requestUrlMap, lookupRow);
    }

    public String factoryIdentifier() {
        return ID;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Set.of();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Set.of(REQUEST_QUERY_PARAM_FIELDS, REQUEST_BODY_FIELDS, REQUEST_URL_MAP);
    }
}

