/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup.querycreators;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.internal.table.lookup.LookupQueryInfo;
import com.getindata.connectors.http.internal.utils.SerializationSchemaUtils;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.FlinkRuntimeException;

public class GenericJsonQueryCreator
implements LookupQueryCreator {
    private final SerializationSchema<RowData> jsonSerialization;
    private boolean schemaOpened = false;

    public GenericJsonQueryCreator(SerializationSchema<RowData> jsonSerialization) {
        this.jsonSerialization = jsonSerialization;
    }

    @Override
    public LookupQueryInfo createLookupQuery(RowData lookupDataRow) {
        this.checkOpened();
        String lookupQuery = new String(this.jsonSerialization.serialize((Object)lookupDataRow), StandardCharsets.UTF_8);
        return new LookupQueryInfo(lookupQuery);
    }

    private void checkOpened() {
        if (!this.schemaOpened) {
            try {
                this.jsonSerialization.open(SerializationSchemaUtils.createSerializationInitContext(GenericJsonQueryCreator.class));
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to initialize serialization schema for GenericJsonQueryCreatorFactory.", (Throwable)e);
            }
            this.schemaOpened = true;
        }
    }
}

