/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.lookup.querycreators;

import com.getindata.connectors.http.LookupQueryCreator;
import com.getindata.connectors.http.LookupQueryCreatorFactory;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.table.lookup.LookupRow;
import com.getindata.connectors.http.internal.table.lookup.querycreators.GenericJsonQueryCreator;
import com.getindata.connectors.http.internal.table.lookup.querycreators.QueryFormatAwareConfiguration;
import com.getindata.connectors.http.internal.utils.SynchronizedSerializationSchema;
import java.util.Set;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

public class GenericJsonQueryCreatorFactory
implements LookupQueryCreatorFactory {
    public static final String IDENTIFIER = "generic-json-query";

    @Override
    public LookupQueryCreator createLookupQueryCreator(ReadableConfig readableConfig, LookupRow lookupRow, DynamicTableFactory.Context dynamicTableFactoryContext) {
        String formatIdentifier = (String)readableConfig.get(HttpLookupConnectorOptions.LOOKUP_REQUEST_FORMAT);
        SerializationFormatFactory jsonFormatFactory = (SerializationFormatFactory)FactoryUtil.discoverFactory((ClassLoader)dynamicTableFactoryContext.getClassLoader(), SerializationFormatFactory.class, (String)formatIdentifier);
        QueryFormatAwareConfiguration queryFormatAwareConfiguration = new QueryFormatAwareConfiguration(HttpLookupConnectorOptions.LOOKUP_REQUEST_FORMAT.key() + "." + formatIdentifier, (Configuration)readableConfig);
        EncodingFormat encoder = jsonFormatFactory.createEncodingFormat(dynamicTableFactoryContext, (ReadableConfig)queryFormatAwareConfiguration);
        SynchronizedSerializationSchema<RowData> serializationSchema = (Boolean)readableConfig.get(HttpLookupConnectorOptions.ASYNC_POLLING) != false ? new SynchronizedSerializationSchema<RowData>((SerializationSchema)encoder.createRuntimeEncoder(null, lookupRow.getLookupPhysicalRowDataType())) : (SynchronizedSerializationSchema<RowData>)encoder.createRuntimeEncoder(null, lookupRow.getLookupPhysicalRowDataType());
        return new GenericJsonQueryCreator(serializationSchema);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Set.of();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Set.of();
    }
}

