/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.sink;

import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.HttpSink;
import com.getindata.connectors.http.HttpSinkBuilder;
import com.getindata.connectors.http.internal.sink.HttpSinkRequestEntry;
import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.sink.httpclient.JavaNetSinkHttpClient;
import com.getindata.connectors.http.internal.table.SerializationSchemaElementConverter;
import com.getindata.connectors.http.internal.table.sink.HttpDynamicSinkConnectorOptions;
import com.getindata.connectors.http.internal.utils.HttpHeaderUtils;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDynamicSink
extends AsyncDynamicTableSink<HttpSinkRequestEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpDynamicSink.class);
    private final DataType consumedDataType;
    private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final HttpPostRequestCallback<HttpRequest> httpPostRequestCallback;
    private final ReadableConfig tableOptions;
    private final Properties properties;

    protected HttpDynamicSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS, DataType consumedDataType, EncodingFormat<SerializationSchema<RowData>> encodingFormat, HttpPostRequestCallback<HttpRequest> httpPostRequestCallback, ReadableConfig tableOptions, Properties properties) {
        super(maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBufferSizeInBytes, maxTimeInBufferMS);
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null");
        this.encodingFormat = (EncodingFormat)Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null");
        this.httpPostRequestCallback = (HttpPostRequestCallback)Preconditions.checkNotNull(httpPostRequestCallback, (String)"Post request callback must not be null");
        this.tableOptions = (ReadableConfig)Preconditions.checkNotNull((Object)tableOptions, (String)"Table options must not be null");
        this.properties = properties;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType);
        String insertMethod = (String)this.tableOptions.get(HttpDynamicSinkConnectorOptions.INSERT_METHOD);
        HttpSinkBuilder<RowData> builder = HttpSink.builder().setEndpointUrl((String)this.tableOptions.get(HttpDynamicSinkConnectorOptions.URL)).setSinkHttpClientBuilder(JavaNetSinkHttpClient::new).setHttpPostRequestCallback(this.httpPostRequestCallback).setHttpHeaderPreprocessor(HttpHeaderUtils.createBasicAuthorizationHeaderPreprocessor()).setElementConverter(new SerializationSchemaElementConverter(insertMethod, (SerializationSchema<RowData>)serializationSchema)).setProperties(this.properties);
        this.addAsyncOptionsToSinkBuilder(builder);
        return SinkV2Provider.of((Sink)builder.build());
    }

    public DynamicTableSink copy() {
        return new HttpDynamicSink(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS, this.consumedDataType, this.encodingFormat, this.httpPostRequestCallback, this.tableOptions, this.properties);
    }

    public String asSummaryString() {
        return "HttpSink";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpDynamicSink)) {
            return false;
        }
        HttpDynamicSink other = (HttpDynamicSink)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataType this$consumedDataType = this.consumedDataType;
        DataType other$consumedDataType = other.consumedDataType;
        if (this$consumedDataType == null ? other$consumedDataType != null : !this$consumedDataType.equals(other$consumedDataType)) {
            return false;
        }
        EncodingFormat<SerializationSchema<RowData>> this$encodingFormat = this.encodingFormat;
        EncodingFormat<SerializationSchema<RowData>> other$encodingFormat = other.encodingFormat;
        if (this$encodingFormat == null ? other$encodingFormat != null : !this$encodingFormat.equals(other$encodingFormat)) {
            return false;
        }
        HttpPostRequestCallback<HttpRequest> this$httpPostRequestCallback = this.httpPostRequestCallback;
        HttpPostRequestCallback<HttpRequest> other$httpPostRequestCallback = other.httpPostRequestCallback;
        if (this$httpPostRequestCallback == null ? other$httpPostRequestCallback != null : !this$httpPostRequestCallback.equals(other$httpPostRequestCallback)) {
            return false;
        }
        ReadableConfig this$tableOptions = this.tableOptions;
        ReadableConfig other$tableOptions = other.tableOptions;
        if (this$tableOptions == null ? other$tableOptions != null : !this$tableOptions.equals(other$tableOptions)) {
            return false;
        }
        Properties this$properties = this.properties;
        Properties other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpDynamicSink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DataType $consumedDataType = this.consumedDataType;
        result = result * 59 + ($consumedDataType == null ? 43 : $consumedDataType.hashCode());
        EncodingFormat<SerializationSchema<RowData>> $encodingFormat = this.encodingFormat;
        result = result * 59 + ($encodingFormat == null ? 43 : $encodingFormat.hashCode());
        HttpPostRequestCallback<HttpRequest> $httpPostRequestCallback = this.httpPostRequestCallback;
        result = result * 59 + ($httpPostRequestCallback == null ? 43 : $httpPostRequestCallback.hashCode());
        ReadableConfig $tableOptions = this.tableOptions;
        result = result * 59 + ($tableOptions == null ? 43 : $tableOptions.hashCode());
        Properties $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public static class HttpDynamicTableSinkBuilder
    extends AsyncDynamicTableSinkBuilder<HttpSinkRequestEntry, HttpDynamicTableSinkBuilder> {
        private final Properties properties = new Properties();
        private ReadableConfig tableOptions;
        private DataType consumedDataType;
        private EncodingFormat<SerializationSchema<RowData>> encodingFormat;
        private HttpPostRequestCallback<HttpRequest> httpPostRequestCallback;

        public HttpDynamicTableSinkBuilder setTableOptions(ReadableConfig tableOptions) {
            this.tableOptions = tableOptions;
            return this;
        }

        public HttpDynamicTableSinkBuilder setEncodingFormat(EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public HttpDynamicTableSinkBuilder setHttpPostRequestCallback(HttpPostRequestCallback<HttpRequest> httpPostRequestCallback) {
            this.httpPostRequestCallback = httpPostRequestCallback;
            return this;
        }

        public HttpDynamicTableSinkBuilder setConsumedDataType(DataType consumedDataType) {
            this.consumedDataType = consumedDataType;
            return this;
        }

        public HttpDynamicTableSinkBuilder setProperty(String propertyName, String propertyValue) {
            this.properties.setProperty(propertyName, propertyValue);
            return this;
        }

        public HttpDynamicTableSinkBuilder setProperties(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        public HttpDynamicSink build() {
            return new HttpDynamicSink(this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBufferSizeInBytes(), this.getMaxTimeInBufferMS(), this.consumedDataType, this.encodingFormat, this.httpPostRequestCallback, this.tableOptions, this.properties);
        }
    }
}

