/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.table.sink;

import com.getindata.connectors.http.HttpPostRequestCallbackFactory;
import com.getindata.connectors.http.internal.table.sink.HttpDynamicSink;
import com.getindata.connectors.http.internal.table.sink.HttpDynamicSinkConnectorOptions;
import com.getindata.connectors.http.internal.utils.ConfigUtils;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.AsyncDynamicTableSinkFactory;
import org.apache.flink.connector.base.table.sink.options.AsyncSinkConfigurationValidator;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class HttpDynamicTableSinkFactory
extends AsyncDynamicTableSinkFactory {
    public static final String IDENTIFIER = "http-sink";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext factoryContext = new AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext((AsyncDynamicTableSinkFactory)this, (AsyncDynamicTableSinkFactory)this, context);
        ReadableConfig tableOptions = factoryContext.getTableOptions();
        FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context).validateExcept(new String[]{"table.", "gid.connector.http."});
        this.validateHttpSinkOptions(tableOptions);
        Properties asyncSinkProperties = new AsyncSinkConfigurationValidator(tableOptions).getValidatedConfigurations();
        HttpPostRequestCallbackFactory postRequestCallbackFactory = (HttpPostRequestCallbackFactory)FactoryUtil.discoverFactory((ClassLoader)context.getClassLoader(), HttpPostRequestCallbackFactory.class, (String)((String)tableOptions.get(HttpDynamicSinkConnectorOptions.REQUEST_CALLBACK_IDENTIFIER)));
        Properties httpConnectorProperties = ConfigUtils.getHttpConnectorProperties(context.getCatalogTable().getOptions());
        HttpDynamicSink.HttpDynamicTableSinkBuilder builder = new HttpDynamicSink.HttpDynamicTableSinkBuilder().setTableOptions(tableOptions).setEncodingFormat((EncodingFormat<SerializationSchema<RowData>>)factoryContext.getEncodingFormat()).setHttpPostRequestCallback(postRequestCallbackFactory.createHttpPostRequestCallback()).setConsumedDataType(factoryContext.getPhysicalDataType()).setProperties(httpConnectorProperties);
        this.addAsyncOptionsToBuilder(asyncSinkProperties, builder);
        return builder.build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Set.of(HttpDynamicSinkConnectorOptions.URL, FactoryUtil.FORMAT);
    }

    public Set<ConfigOption<?>> optionalOptions() {
        Set options = super.optionalOptions();
        options.add(HttpDynamicSinkConnectorOptions.INSERT_METHOD);
        options.add(HttpDynamicSinkConnectorOptions.REQUEST_CALLBACK_IDENTIFIER);
        return options;
    }

    private void validateHttpSinkOptions(ReadableConfig tableOptions) throws IllegalArgumentException {
        tableOptions.getOptional(HttpDynamicSinkConnectorOptions.INSERT_METHOD).ifPresent(insertMethod -> {
            if (!Set.of("POST", "PUT").contains(insertMethod)) {
                throw new IllegalArgumentException(String.format("Invalid option '%s'. It is expected to be either 'POST' or 'PUT'.", HttpDynamicSinkConnectorOptions.INSERT_METHOD.key()));
            }
        });
    }
}

