/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils;

import com.getindata.connectors.http.internal.config.ConfigException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.util.StringUtils;

public final class ConfigUtils {
    public static final String UNIVERSAL_NEW_LINE_REGEXP = "\\R";
    private static final String PROPERTY_NAME_DELIMITER = ".";

    public static <T> Map<String, T> propertiesToMap(Properties properties, String keyPrefix, Class<T> valueClazz) {
        HashMap map = new HashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String) {
                String key = (String)entry.getKey();
                if (!key.startsWith(keyPrefix)) continue;
                ConfigUtils.tryAddToConfigMap(properties, valueClazz, map, key);
                continue;
            }
            throw new ConfigException(entry.getKey().toString(), entry.getValue(), "Key must be a string.");
        }
        return map;
    }

    public static String extractPropertyLastElement(String propertyKey) {
        if (StringUtils.isNullOrWhitespaceOnly((String)propertyKey)) {
            throw new ConfigException("Provided a property name that is null, empty or blank.");
        }
        if (!propertyKey.contains(PROPERTY_NAME_DELIMITER)) {
            return propertyKey;
        }
        int delimiterLastIndex = propertyKey.lastIndexOf(PROPERTY_NAME_DELIMITER);
        if (delimiterLastIndex == propertyKey.length() - 1) {
            throw new ConfigException(String.format("Invalid property - %s. Property name should not end with property delimiter.", propertyKey));
        }
        return propertyKey.substring(delimiterLastIndex + 1);
    }

    private static <T> void tryAddToConfigMap(Properties properties, Class<T> clazz, Map<String, T> map, String key) {
        try {
            map.put(key, clazz.cast(properties.get(key)));
        }
        catch (ClassCastException e) {
            throw new ConfigException(String.format("Unable to cast value for property %s to type %s", key, clazz), e);
        }
    }

    public static Properties getHttpConnectorProperties(Map<String, String> tableOptions) {
        Properties httpProperties = new Properties();
        tableOptions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("gid.connector.http.")).forEach(entry -> httpProperties.put(entry.getKey(), entry.getValue()));
        return httpProperties;
    }
}

