/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils;

import com.getindata.connectors.http.internal.BasicAuthHeaderValuePreprocessor;
import com.getindata.connectors.http.internal.ComposeHeaderPreprocessor;
import com.getindata.connectors.http.internal.HeaderPreprocessor;
import com.getindata.connectors.http.internal.OIDCAuthHeaderValuePreprocessor;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.utils.ConfigUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.flink.configuration.ReadableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpHeaderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHeaderUtils.class);
    public static final String AUTHORIZATION = "Authorization";

    public static Map<String, String> prepareHeaderMap(String headerKeyPrefix, Properties properties, HeaderPreprocessor headerPreprocessor) {
        Map<String, String> propertyHeaderMap = ConfigUtils.propertiesToMap(properties, headerKeyPrefix, String.class);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Map.Entry<String, String> headerAndValue : propertyHeaderMap.entrySet()) {
            String propertyName = headerAndValue.getKey();
            String headerValue = headerAndValue.getValue();
            log.info("prepareHeaderMap propertyName=" + propertyName + ",headerValue" + headerValue);
            String headerName = ConfigUtils.extractPropertyLastElement(propertyName);
            String preProcessedHeader = headerPreprocessor.preprocessValueForHeader(headerName, headerValue);
            log.info("prepareHeaderMap preProcessedHeader=" + preProcessedHeader);
            headerMap.put(headerName, preProcessedHeader);
        }
        return headerMap;
    }

    public static String[] toHeaderAndValueArray(Map<String, String> headerMap) {
        return (String[])headerMap.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).toArray(String[]::new);
    }

    public static HeaderPreprocessor createBasicAuthorizationHeaderPreprocessor() {
        return HttpHeaderUtils.createBasicAuthorizationHeaderPreprocessor(false);
    }

    public static HeaderPreprocessor createBasicAuthorizationHeaderPreprocessor(boolean useRawAuthHeader) {
        return new ComposeHeaderPreprocessor(Collections.singletonMap(AUTHORIZATION, new BasicAuthHeaderValuePreprocessor(useRawAuthHeader)));
    }

    public static HeaderPreprocessor createOIDCAuthorizationHeaderPreprocessor(String oidcAuthURL, String oidcTokenRequest, Optional<Duration> oidcExpiryReduction) {
        return new ComposeHeaderPreprocessor(Collections.singletonMap(AUTHORIZATION, new OIDCAuthHeaderValuePreprocessor(oidcAuthURL, oidcTokenRequest, oidcExpiryReduction)));
    }

    public static HeaderPreprocessor createHeaderPreprocessor(ReadableConfig readableConfig) {
        boolean useRawAuthHeader = (Boolean)readableConfig.get(HttpLookupConnectorOptions.USE_RAW_AUTH_HEADER);
        HeaderPreprocessor headerPreprocessor = HttpHeaderUtils.createBasicAuthorizationHeaderPreprocessor(useRawAuthHeader);
        log.info("created HeaderPreprocessor for basic useRawAuthHeader=" + useRawAuthHeader);
        log.info("returning HeaderPreprocessor " + String.valueOf(headerPreprocessor));
        return headerPreprocessor;
    }

    public static HeaderPreprocessor createOIDCHeaderPreprocessor(ReadableConfig readableConfig) {
        HeaderPreprocessor headerPreprocessor = null;
        Optional oidcAuthURL = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_ENDPOINT_URL);
        if (oidcAuthURL.isPresent()) {
            Optional oidcTokenRequest = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_REQUEST);
            Optional oidcExpiryReduction = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_OIDC_AUTH_TOKEN_EXPIRY_REDUCTION);
            headerPreprocessor = HttpHeaderUtils.createOIDCAuthorizationHeaderPreprocessor((String)oidcAuthURL.get(), (String)oidcTokenRequest.get(), oidcExpiryReduction);
            log.info("created HeaderPreprocessor " + String.valueOf(headerPreprocessor) + " for OIDC oidcAuthURL=" + String.valueOf(oidcAuthURL) + ", oidcTokenRequest=" + String.valueOf(oidcTokenRequest) + ", oidcExpiryReduction=" + String.valueOf(oidcExpiryReduction));
        }
        return headerPreprocessor;
    }
}

