/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils;

import com.getindata.connectors.http.internal.security.SecurityContext;
import com.getindata.connectors.http.internal.security.SelfSignedTrustManager;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConfig;
import com.getindata.connectors.http.internal.table.lookup.HttpLookupConnectorOptions;
import com.getindata.connectors.http.internal.utils.ProxyConfig;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaNetHttpClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaNetHttpClientFactory.class);

    public static HttpClient createClient(HttpLookupConfig options) {
        SSLContext sslContext = JavaNetHttpClientFactory.getSslContext(options.getProperties());
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).sslContext(sslContext);
        ReadableConfig readableConfig = options.getReadableConfig();
        readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_CONNECTION_TIMEOUT).ifPresent(clientBuilder::connectTimeout);
        Optional proxyHost = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_HOST);
        Optional proxyPort = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_PORT);
        if (proxyHost.isPresent() && proxyPort.isPresent()) {
            Optional proxyUsername = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_USERNAME);
            Optional proxyPassword = readableConfig.getOptional(HttpLookupConnectorOptions.SOURCE_LOOKUP_PROXY_PASSWORD);
            ProxyConfig proxyConfig = new ProxyConfig((String)proxyHost.get(), (Integer)proxyPort.get(), proxyUsername, proxyPassword);
            clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort())));
            proxyConfig.getAuthenticator().ifPresent(clientBuilder::authenticator);
        }
        return clientBuilder.build();
    }

    public static HttpClient createClient(Properties properties, Executor executor) {
        SSLContext sslContext = JavaNetHttpClientFactory.getSslContext(properties);
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).sslContext(sslContext).executor(executor).build();
    }

    private static SSLContext getSslContext(Properties properties) {
        String keyStorePath = properties.getProperty("gid.connector.http.security.keystore.path", "");
        boolean selfSignedCert = Boolean.parseBoolean(properties.getProperty("gid.connector.http.security.cert.server.allowSelfSigned", "false"));
        String[] serverTrustedCerts = properties.getProperty("gid.connector.http.security.cert.server", "").split(",");
        String clientCert = properties.getProperty("gid.connector.http.security.cert.client", "");
        String clientPrivateKey = properties.getProperty("gid.connector.http.security.key.client", "");
        if (StringUtils.isNullOrWhitespaceOnly((String)keyStorePath) && !selfSignedCert && properties.getProperty("gid.connector.http.security.cert.server") == null && StringUtils.isNullOrWhitespaceOnly((String)clientCert) && StringUtils.isNullOrWhitespaceOnly((String)clientPrivateKey)) {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        SecurityContext securityContext = JavaNetHttpClientFactory.createSecurityContext(properties);
        for (String cert : serverTrustedCerts) {
            if (StringUtils.isNullOrWhitespaceOnly((String)cert)) continue;
            securityContext.addCertToTrustStore(cert);
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)clientCert) && !StringUtils.isNullOrWhitespaceOnly((String)clientPrivateKey)) {
            securityContext.addMTlsCerts(clientCert, clientPrivateKey);
        }
        TrustManager[] trustManagers = JavaNetHttpClientFactory.getTrustedManagers(securityContext, selfSignedCert);
        return securityContext.getSslContext(trustManagers);
    }

    private static TrustManager[] getTrustedManagers(SecurityContext securityContext, boolean selfSignedCert) {
        TrustManager[] trustManagers = securityContext.getTrustManagers();
        if (selfSignedCert) {
            return JavaNetHttpClientFactory.wrapWithSelfSignedManagers(trustManagers).toArray(new TrustManager[0]);
        }
        return trustManagers;
    }

    private static List<TrustManager> wrapWithSelfSignedManagers(TrustManager[] trustManagers) {
        log.warn("Creating Trust Managers for self-signed certificates - not Recommended. Use [gid.connector.http.security.cert.server] connector property to add certificated as trusted.");
        ArrayList<TrustManager> selfSignedManagers = new ArrayList<TrustManager>(trustManagers.length);
        for (TrustManager trustManager : trustManagers) {
            selfSignedManagers.add(new SelfSignedTrustManager((X509TrustManager)trustManager));
        }
        return selfSignedManagers;
    }

    private static SecurityContext createSecurityContext(Properties properties) {
        String keyStorePath = properties.getProperty("gid.connector.http.security.keystore.path", "");
        if (StringUtils.isNullOrWhitespaceOnly((String)keyStorePath)) {
            return SecurityContext.create();
        }
        char[] storePassword = properties.getProperty("gid.connector.http.security.keystore.password", "").toCharArray();
        if (storePassword.length == 0) {
            throw new RuntimeException("Missing password for provided KeyStore");
        }
        return SecurityContext.createFromKeyStore(keyStorePath, storePassword);
    }
}

